package org.openmetadata.beans.ddi.lifecycle.physicalinstance.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.CategoryStatisticBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.CategoryStatisticQuery;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.CategoryStatisticsBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.InstanceDatasetBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.SummaryStatisticQuery;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.SummaryStatisticBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.VariableStatisticsBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public class InstanceDatasetBeanImpl extends UnsettableDdiBeanImpl implements InstanceDatasetBean {
	
	private Map<String, Set<SummaryStatisticBean>> var2SummaryStatMap;
	private Map<String, Set<CategoryStatisticsBean>> var2CategoryStatsMap;

	public InstanceDatasetBeanImpl(DdiBeanFactory beanFactory,
			ChangeListener changeListener) {
		super(beanFactory, changeListener);
		
		this.var2SummaryStatMap = new HashMap<String, Set<SummaryStatisticBean>>();
		this.var2CategoryStatsMap = new HashMap<String, Set<CategoryStatisticsBean>>();
	}
	
	public void initSetSummaryStatistics(VariableStatisticsBean[] varStatsArray) {
		this.var2SummaryStatMap.clear();
		
		for(VariableStatisticsBean varStats : varStatsArray) {
			String variableUrn = varStats.getVariableUrn();
			
			for(SummaryStatisticBean summaryStats : varStats.getSummaryStatisticList()){				
				if(!var2SummaryStatMap.containsKey(variableUrn)){
					var2SummaryStatMap.put(variableUrn, new HashSet<SummaryStatisticBean>());
				}
				var2SummaryStatMap.get(variableUrn).add(summaryStats);				
			}
			
			for(CategoryStatisticsBean ctgStats : varStats.getCategoryStatisticsList()){
				if(!var2CategoryStatsMap.containsKey(variableUrn)) {
					var2CategoryStatsMap.put(variableUrn, new HashSet<CategoryStatisticsBean>());
				}
				var2CategoryStatsMap.get(variableUrn).add(ctgStats);
			}			
		}
	}

	@Override
	public SummaryStatisticBean[] getSummaryStatistics(
			SummaryStatisticQuery query) {
		
		if(query.isSetVariable()) {
			VariableBean variable = query.getVariable();
			if(var2SummaryStatMap.containsKey(variable.getUrn())) {
				
				Set<SummaryStatisticBean> statsForVar = var2SummaryStatMap.get(variable.getUrn());
				Set<SummaryStatisticBean> statsForVarWithRequiredWeight = 
						new HashSet<SummaryStatisticBean>();
				for(SummaryStatisticBean stat : statsForVar) {
					if(stat.getWeighted() == query.getIsWeighted()){
						statsForVarWithRequiredWeight.add(stat);
					}
				}				
				return statsForVarWithRequiredWeight.toArray(new SummaryStatisticBean[0]);
			}
		}
		
		return new SummaryStatisticBean[0];
	}	
	
	@Override
	public CategoryStatisticBean[] getCategoryStatistics(
			CategoryStatisticQuery query) {
		if(query.isSetVariable()) {
			VariableBean variable = query.getVariable();
			if(var2CategoryStatsMap.containsKey(variable.getUrn())) {
				Set<CategoryStatisticsBean> statsForVarSet = 
						var2CategoryStatsMap.get(variable.getUrn());
			
				Set<CategoryStatisticBean> result = new HashSet<CategoryStatisticBean>();
				for(CategoryStatisticsBean statsForVar : statsForVarSet) {
					for(CategoryStatisticBean categoryStat : statsForVar.getCategoryStaticList()){
						String currStatType = categoryStat.getCategoryStatisticType().getStringValue();						
						
						boolean typeMatch = currStatType.equalsIgnoreCase(query.getCategoryStatisticType());
						boolean weightPropMatch = categoryStat.getIsWeighted()==query.getIsWeighted();
						
						if(typeMatch && weightPropMatch) {
							if(query.isSetCategoryValue()){
								if(categoryStat.getCategoryValue().equalsIgnoreCase(query.getCategoryValue())) {
									result.add(categoryStat);
								}
							}else{
								result.add(categoryStat);
							}
						}
					}
				}
				return result.toArray(new CategoryStatisticBean[0]);
			}			
		}
		return new CategoryStatisticBean[0];
	}

	@Override
	protected boolean internalIsSet() {
		return var2SummaryStatMap.size() > 0;
	}

}
