package org.openmetadata.beans.ddi.lifecycle.physicalinstance;

import org.openmetadata.beans.ddi.lifecycle.adt.SchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.ReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.RecordLayoutBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.CitationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.CodeValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.CoverageBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.MaintainableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.ProprietaryInfoBean;
import org.openmetadata.beans.exceptions.FactoryException;
import org.openmetadata.ddi_3_1.util.DdiClass;

public interface PhysicalInstanceBean extends MaintainableBean {
	
	public final static DdiClass ddiClass = DdiClass.PhysicalInstance;

	CitationBean getCitation();

	CoverageBean getCoverage();

	ReferenceSet<RecordLayoutBean> getRecordLayoutList();

	SchemeItemList<DataFileIdentificationBean> getDataIdentifications();

	boolean isSetGrossFileStructure();

	GrossFileStructureBean getGrossFileStructure();

	void addNewGrossFileStructure() throws FactoryException;

	void unsetGrossFileStructure();

	ProprietaryInfoBean getProprietaryInfo();

	StatisticsBean getStatistics();
	
	InstanceDatasetBean getDataset();

	CodeValueBean getByteOrder();
}