package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ResolvingSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.SchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CategorySchemeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.DataRelationshipBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.LogicalProductBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NoteBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.OtherMaterialBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CoverageBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

/**
 * Describes the logical content of the standard variables
 * 
 * @author Kyaw
 * 
 */
public class LogicalProductBeanImpl extends AbstractMaintainableBeanImpl
		implements LogicalProductBean {

	private CoverageBeanImpl coverageBean;
	private SchemeItemListImpl<DataRelationshipBean> dataRelationshipList;
	private SchemeItemListImpl<OtherMaterialBean> otherMaterialBeanList;
	private SchemeItemListImpl<NoteBean> noteBeanList;

	private ReferenceSetImpl<VariableSchemeBean> variableSchemes;
	private ReferenceSetImpl<CategorySchemeBean> categorySchemes;
	private ReferenceSetImpl<CodeSchemeBean> codeSchemes;

	public LogicalProductBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);

		variableSchemes = new ReferenceSetImpl<VariableSchemeBean>(
				VariableSchemeBean.class, beanInitializer, factory, this);
		dataRelationshipList = new ResolvingSchemeItemListImpl<DataRelationshipBean>(
				urn.toString(), DataRelationshipBean.class, beanInitializer, factory, this);

		categorySchemes = new ReferenceSetImpl<CategorySchemeBean>(
				CategorySchemeBean.class, beanInitializer, factory, this);
		codeSchemes = new ReferenceSetImpl<CodeSchemeBean>(
				CodeSchemeBean.class, beanInitializer, factory, this);

		otherMaterialBeanList = new ResolvingSchemeItemListImpl<OtherMaterialBean>(
				urn.toString(), OtherMaterialBean.class, beanInitializer, factory, this);
		noteBeanList = new ResolvingSchemeItemListImpl<NoteBean>(urn.toString(),
				NoteBean.class, beanInitializer, factory, this);

		coverageBean = new CoverageBeanImpl(beanInitializer, factory, this);
	}

	public void initSetVariableSchemes(String[] urns) {
		variableSchemes.initReferenceUrns(urns);
	}

	public void initSetDataRelationships(String[] urns) {
		dataRelationshipList.initSetIdentifiableUrns(urns);
	}

	public void initSetCategorySchemes(String[] urns) {
		categorySchemes.initReferenceUrns(urns);
	}

	public void initSetCodeSchemes(String[] urns) {
		codeSchemes.initReferenceUrns(urns);
	}

	public void initSetOtherMaterials(String[] urns) {
		otherMaterialBeanList.initSetIdentifiableUrns(urns);
	}

	public void initSetNotes(String[] urns) {
		noteBeanList.initSetIdentifiableUrns(urns);
	}

	@Override
	public CoverageBeanImpl getCoverage() {
		return coverageBean;
	}

	@Override
	public SchemeItemListImpl<DataRelationshipBean> getDataRelationshipList() {
		return dataRelationshipList;
	}

	@Override
	public SchemeItemListImpl<OtherMaterialBean> getOtherMaterialList() {
		return otherMaterialBeanList;
	}

	@Override
	public SchemeItemListImpl<NoteBean> getNoteList() {
		return noteBeanList;
	}

	@Override
	public ReferenceSetImpl<CategorySchemeBean> getCategorySchemeList() {
		return categorySchemes;
	}

	@Override
	public ReferenceSetImpl<CodeSchemeBean> getCodeSchemeList() {
		return codeSchemes;
	}

	@Override
	public ReferenceSetImpl<VariableSchemeBean> getVariableSchemeList() {
		return variableSchemes;
	}

	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another) {
		if (current instanceof VariableSchemeBean
				&& another instanceof VariableSchemeBean) {
			VariableSchemeBean currVarScheme = (VariableSchemeBean) current;
			if (this.getVariableSchemeList().contains(currVarScheme)) {
				this.getVariableSchemeList().remove(currVarScheme);
				this.getVariableSchemeList().add((VariableSchemeBean) another);
			}
		} else if (current instanceof CategorySchemeBean
				&& another instanceof CategorySchemeBean) {
			CategorySchemeBean currCtgScheme = (CategorySchemeBean) current;
			if (this.getCategorySchemeList().contains(currCtgScheme)) {
				this.getCategorySchemeList().remove(currCtgScheme);
				this.getCategorySchemeList().add((CategorySchemeBean) another);
			}
		} else if (current instanceof CodeSchemeBean
				&& another instanceof CodeSchemeBean) {
			CodeSchemeBean currCodeScheme = (CodeSchemeBean) current;
			if (this.getCodeSchemeList().contains(currCodeScheme)) {
				this.getCodeSchemeList().remove(currCodeScheme);
				this.getCodeSchemeList().add((CodeSchemeBean) another);
			}
		}
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		if (toRemove instanceof VariableSchemeBean) {
			VariableSchemeBean toRemoveScheme = (VariableSchemeBean) toRemove;
			if (this.getVariableSchemeList().contains(toRemoveScheme)) {
				this.getVariableSchemeList().remove(toRemoveScheme);
			}
		} else if (toRemove instanceof CategorySchemeBean) {
			CategorySchemeBean toRemoveScheme = (CategorySchemeBean) toRemove;
			if (this.getCategorySchemeList().contains(toRemoveScheme)) {
				this.getCategorySchemeList().remove(toRemoveScheme);
			}
		} else if (toRemove instanceof CodeSchemeBean) {
			CodeSchemeBean toRemoveScheme = (CodeSchemeBean) toRemove;
			if (this.getCodeSchemeList().contains(toRemoveScheme)) {
				this.getCodeSchemeList().remove(toRemoveScheme);
			}
		}
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.LogicalProduct;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return LogicalProductBean.class;
	}
}
