package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import org.openmetadata.beans.ddi.lifecycle.datacollection.LiteralTextBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.LiteralTextValueBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public class LiteralTextValueBeanImpl extends UnsettableDdiBeanImpl implements
		LiteralTextValueBean {

	private List<LiteralTextBean> beanList;
	private String defaultLang;

	public LiteralTextValueBeanImpl(String defaultLang, DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);
		beanList = new ArrayList<LiteralTextBean>();
		this.defaultLang = defaultLang;
	}

	@Override
	public Collection<LiteralTextBean> getAllValues() {
		return beanList;
	}

	@Override
	public LiteralTextBean getFirst() {
		if (beanList.size() > 0) {
			return beanList.get(0);
		} else {
			LiteralTextBean bean = new LiteralTextBeanImpl(defaultLang, new HashMap<Enum<?>, Object>(),
					this.getBeanFactory(), this);
			beanList.add(bean);
			return bean;
		}
	}

	@Override
	protected boolean internalIsSet() {
		return beanList.isEmpty()==false;
	}
}
