package org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractSchemeItemBean;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public class ConceptBeanImpl extends AbstractSchemeItemBean<ConceptSchemeBean>
		implements ConceptBean {

	private ReferenceSetImpl<ConceptBean> similarConcepts;

	public ConceptBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		similarConcepts = new ReferenceSetImpl<ConceptBean>(ConceptBean.class,
				beanInitializer,
				factory, this);
	}

	public void initSetSimilarConcepts(String[] similarConceptUrns) {
		similarConcepts.initReferenceUrns(similarConceptUrns);
	}

	@Override
	public ReferenceSetImpl<ConceptBean> getSimilarConceptList() {
		return this.similarConcepts;
	}

	@Override
	public void doChangeReference(IdentifiableBean toDerefer,
			IdentifiableBean toRefer) {
		if (toDerefer instanceof ConceptBean && toRefer instanceof ConceptBean) {
			ConceptBean conceptToDerefer = (ConceptBean) toDerefer;
			ConceptBean conceptToRefer = (ConceptBean) toRefer;
			if (similarConcepts.contains(conceptToDerefer)) {
				similarConcepts.remove(conceptToDerefer);
				similarConcepts.add(conceptToRefer);
			}
		}
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		if (toRemove instanceof ConceptBean) {
			ConceptBean concept = (ConceptBean) toRemove;
			if (similarConcepts.contains(concept)) {
				similarConcepts.remove(concept);
			}
		}
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.Concept;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return ConceptBean.class;
	}
}
