package org.openmetadata.beans.ddi.lifecycle.adt.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.openmetadata.beans.ddi.lifecycle.adt.ReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;

public abstract class CompositeReferenceSetImpl<B extends IdentifiableBean>
		implements ReferenceSet<B> {

	private List<ReferenceSet<? extends B>> refSetList = new ArrayList<ReferenceSet<? extends B>>();

	public CompositeReferenceSetImpl(ReferenceSet<? extends B>... sets) {
		for (ReferenceSet<? extends B> set : sets) {
			refSetList.add(set);
		}
	}

	@Override
	public Iterator<B> iterator() {
		List<B> superList = new ArrayList<B>();
		for (ReferenceSet<? extends B> set : refSetList) {
			for (B bean : set) {
				superList.add(bean);
			}
		}
		return superList.iterator();
	}

	@Override
	public boolean contains(B bean) {
		for (ReferenceSet<? extends B> set : refSetList) {
			if (set.contains(bean.getUrn())) {
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean contains(String urn) {
		for (ReferenceSet<? extends B> set : refSetList) {
			if (set.contains(urn)) {
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean remove(B bean) {
		for (ReferenceSet<? extends B> set : refSetList) {
			if (set.contains(bean.getUrn())) {
				set.remove(bean.getUrn());
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean remove(String urn) {
		for (ReferenceSet<? extends B> set : refSetList) {
			if (set.contains(urn)) {
				set.remove(urn);
				return true;
			}
		}
		return false;
	}

	@Override
	public B[] toArray(B[] arr) {
		List<B> superList = new ArrayList<B>();
		for (ReferenceSet<? extends B> set : refSetList) {
			for (B bean : set) {
				superList.add(bean);
			}
		}
		return superList.toArray(arr);
	}

	@Override
	public int size() {
		int total = 0;
		for (ReferenceSet<? extends B> set : refSetList) {
			total += set.size();
		}
		return total;
	}
}
