/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import java.util.HashSet;
import java.util.Set;
import org.openmetadata.beans.ddi.lifecycle.adt.ResolvingSet;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.notification.ReferenceChangeEvent;
import org.openmetadata.beans.ddi.lifecycle.reusable.ActionCode;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.LabelBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.LanguageKeyedBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NameBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.StructuredStringBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AttributeSetImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.LabelValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.NameValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.StructuredStringValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UserIDValueBeanImpl;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.impl.MutableIdentifiableBeanImpl;
import org.openmetadata.beans.notification.ChangeEvent;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.beans.notification.IdentifiableChangeEvent;
import org.openmetadata.beans.reference.Resolver;
import org.openmetadata.ddi_3_1.util.URN;

public abstract class AbstractIdentifiableBeanImpl
extends MutableIdentifiableBeanImpl
implements IdentifiableBean {
    private final String id;
    private final String urn;
    private String objectSource;
    private ActionCode action;
    private AttributeSetImpl attrSet;
    private NameValueBeanImpl name;
    private LabelValueBeanImpl label;
    private StructuredStringValueBeanImpl description;
    private UserIDValueBeanImpl userIdValues;
    private final DdiBeanFactory beanFactory;
    private final MutableBeanInitializer beanInitializer;

    protected abstract void doChangeReference(IdentifiableBean var1, IdentifiableBean var2);

    protected abstract void doRemoveReference(IdentifiableBean var1);

    private static URN getParentURN(URN urn) {
        if (urn.hasParent()) {
            return urn.getParent();
        }
        return urn;
    }

    public AbstractIdentifiableBeanImpl(Boolean newInstance, URN urn, MutableBeanInitializer beanInitializer, DdiBeanFactory beanFactory) {
        super(newInstance.booleanValue(), urn.toString(), AbstractIdentifiableBeanImpl.getParentURN(urn).toString(), beanInitializer);
        this.beanInitializer = beanInitializer;
        this.beanFactory = beanFactory;
        this.id = urn.getId();
        this.urn = urn.toString();
        this.attrSet = new AttributeSetImpl();
        this.name = new NameValueBeanImpl(beanFactory, (ChangeListener)this);
        this.label = new LabelValueBeanImpl(beanFactory, (ChangeListener)this);
        this.description = new StructuredStringValueBeanImpl(beanFactory, (ChangeListener)this);
        this.userIdValues = new UserIDValueBeanImpl(beanFactory, (ChangeListener)this);
    }

    protected MutableBeanInitializer getBeanInitializer() {
        return this.beanInitializer;
    }

    protected DdiBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected Resolver getResolver() {
        return this.beanFactory;
    }

    protected final void handleChange(IdentifiableChangeEvent event) {
    }

    @Override
    public AttributeSetImpl getAttributeSet() {
        return this.attrSet;
    }

    @Override
    public IdentifiableBean[] getReferrers() {
        Set referringUrnSet = this.beanFactory.getReferrers(this.getUrn());
        try {
            Set set = this.beanFactory.resolve(IdentifiableBean.class, referringUrnSet);
            return set.toArray(new IdentifiableBean[0]);
        }
        catch (ResolverException e1) {
            return new IdentifiableBean[0];
        }
    }

    @Override
    public ResolvingSet<IdentifiableBean> getReferrerSet() {
        Set referringUrnSet = this.beanFactory.getReferrers(this.getUrn());
        return new ResolvingSet<IdentifiableBean>(referringUrnSet, IdentifiableBean.class, (Resolver)this.beanFactory);
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getUrn() {
        return this.urn;
    }

    @Override
    public boolean isSetUrn() {
        return this.urn != null;
    }

    @Override
    public String getObjectSource() {
        return this.objectSource != null ? this.objectSource : "";
    }

    @Override
    public void setObjectSource(String value) {
        this.objectSource = value;
        this.change();
    }

    @Override
    public boolean isSetObjectSource() {
        return this.objectSource != null;
    }

    @Override
    public ActionCode getAction() {
        return this.action;
    }

    @Override
    public boolean isSetAction() {
        return this.action != null;
    }

    @Override
    public void setAction(ActionCode arg0) {
        if (this.action != arg0) {
            this.action = arg0;
            this.change();
        }
    }

    @Override
    public UserIDValueBeanImpl getUserIDValues() {
        return this.userIdValues;
    }

    @Override
    public NameValueBeanImpl getName() {
        return this.name;
    }

    @Override
    public LabelValueBeanImpl getLabel() {
        return this.label;
    }

    @Override
    public StructuredStringValueBeanImpl getDescription() {
        return this.description;
    }

    @Override
    public void copyNameLabelDescription(IdentifiableBean from) {
        this.getName().unset();
        LanguageKeyedBean[] languageKeyedBeanArray = (NameBean[])from.getName().getAllValues();
        int n = languageKeyedBeanArray.length;
        int n2 = 0;
        while (n2 < n) {
            NameBean name = languageKeyedBeanArray[n2];
            ((NameBean)this.getName().getBean(name.getLanguage())).setStringValue(name.getStringValue());
            ++n2;
        }
        this.getLabel().unset();
        languageKeyedBeanArray = (LabelBean[])from.getLabel().getAllValues();
        n = languageKeyedBeanArray.length;
        n2 = 0;
        while (n2 < n) {
            LanguageKeyedBean label = languageKeyedBeanArray[n2];
            ((LabelBean)this.getLabel().getBean(label.getLanguage())).setXhtmlContent(label.getXhtmlContent());
            ++n2;
        }
        this.getDescription().unset();
        languageKeyedBeanArray = (StructuredStringBean[])from.getDescription().getAllValues();
        n = languageKeyedBeanArray.length;
        n2 = 0;
        while (n2 < n) {
            LanguageKeyedBean sstr = languageKeyedBeanArray[n2];
            ((StructuredStringBean)this.getDescription().getBean(sstr.getLanguage())).setXhtmlContent(sstr.getXhtmlContent());
            ++n2;
        }
    }

    @Override
    public final void changeReference(IdentifiableBean current, IdentifiableBean another) {
        if (current != null) {
            if (another != null) {
                this.doChangeReference(current, another);
            } else {
                this.doRemoveReference(current);
            }
        }
    }

    @Override
    public final void removeReference(IdentifiableBean toRemove) {
        if (toRemove != null) {
            this.doRemoveReference(toRemove);
        }
    }

    protected Set<String> getReferenceAdditions(ChangeEvent event) {
        HashSet<String> additions = new HashSet<String>();
        if (!(event instanceof IdentifiableChangeEvent)) {
            if (event instanceof ReferenceChangeEvent) {
                ReferenceChangeEvent refChangeEvent = (ReferenceChangeEvent)event;
                additions.addAll(refChangeEvent.getAddedReferences());
            }
            ChangeEvent[] changeEventArray = event.getInitiatingEvents();
            int n = changeEventArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeEvent initiatingEvent = changeEventArray[n2];
                additions.addAll(this.getReferenceAdditions(initiatingEvent));
                ++n2;
            }
        }
        return additions;
    }

    protected Set<String> getReferenceDeletions(ChangeEvent event) {
        HashSet<String> deletions = new HashSet<String>();
        if (!(event instanceof IdentifiableChangeEvent)) {
            if (event instanceof ReferenceChangeEvent) {
                ReferenceChangeEvent refChangeEvent = (ReferenceChangeEvent)event;
                deletions.addAll(refChangeEvent.getRemovedReferences());
            }
            ChangeEvent[] changeEventArray = event.getInitiatingEvents();
            int n = changeEventArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeEvent initiatingEvent = changeEventArray[n2];
                deletions.addAll(this.getReferenceDeletions(initiatingEvent));
                ++n2;
            }
        }
        return deletions;
    }
}

