package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.BaseDateBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.DateBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.DateRangeBean;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class DateBeanImpl extends UnsettableDdiBeanImpl implements DateBean {

	private String calendarStr;
	private BaseDateBeanImpl simpleDateBean;
	private DateRangeBeanImpl dateRangeBean;

	private boolean isRange = false;

	public DateBeanImpl(MutableBeanInitializer beanInitializer, DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);

		simpleDateBean = new BaseDateBeanImpl(factory, this);
		dateRangeBean = new DateRangeBeanImpl(beanInitializer, factory, this);
		isRange = false;
	}

	@Override
	public boolean isSetCalendar() {
		return (calendarStr != null) && (!calendarStr.isEmpty());
	}

	@Override
	public String getCalendar() {
		return StringUtils.defaultString(calendarStr);
	}

	@Override
	public void setCaleander(String calendar) {
		if (CompareUtil.areDifferentValues(this.calendarStr, calendar)) {
			this.calendarStr = calendar;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public BaseDateBean getSimpleDate() {
		return simpleDateBean;
	}

	@Override
	public DateRangeBean getDateRange() {
		return dateRangeBean;
	}

	@Override
	public void setIsRange(boolean isRange) {
		this.isRange = isRange;
		this.ddiBeanChanged();
	}

	@Override
	public boolean isRange() {
		return this.isRange;
	}

	@Override
	public boolean internalIsSet() {
		return simpleDateBean.isSet() || dateRangeBean.isSet();
	}

}
