package org.openmetadata.beans.ddi.lifecycle.reusable;

import java.util.Map;

import org.openmetadata.beans.ddi.lifecycle.adt.KeyedValueBean;

public interface LanguageKeyedValueBean<B extends LanguageKeyedBean> extends KeyedValueBean<B>{
	
	B[] findBeans(String lang);

	/**
	 * Return an instance with the specified language as the only key
	 * @param lang
	 * @return
	 */
	B getBean(String lang);
	
	B getBean(String lang, Map<Enum<?>, Object> keyMap);
	
	void removeAllByLanguage(String lang);
}
