package org.openmetadata.beans.ddi.lifecycle.notification;

import java.util.HashSet;
import java.util.Set;

import org.openmetadata.beans.notification.ChangeEvent;

public class ReferenceReplacedEvent implements ReferenceChangeEvent {

	private Set<String> addedReferences = new HashSet<String>();
	private Set<String> removedReferences = new HashSet<String>();

	public ReferenceReplacedEvent(String added, String deleted) {
		if (added != null) {
			addedReferences.add(added);
		}
		if (deleted != null) {
			removedReferences.add(deleted);
		}
	}

	public ReferenceReplacedEvent(Set<String> added, Set<String> deleted) {
		addedReferences.addAll(added);
		removedReferences.addAll(deleted);
	}

	@Override
	public ChangeEvent[] getInitiatingEvents() {
		return new ChangeEvent[0];
	}

	@Override
	public Type getType() {
		return Type.UPDATE;
	}

	@Override
	public Set<String> getAddedReferences() {
		return addedReferences;
	}

	@Override
	public Set<String> getRemovedReferences() {
		return removedReferences;
	}
}
