package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.InitializingSchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ResolvingSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionItemBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public class QuestionSchemeBeanImpl extends AbstractMaintainableBeanImpl
		implements QuestionSchemeBean {

	private InitializingSchemeItemList<QuestionItemBean> questionItemList;

	public QuestionSchemeBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		questionItemList = new ResolvingSchemeItemListImpl<QuestionItemBean>(
				this.getUrn(), QuestionItemBean.class, beanInitializer, factory, this);
	}

	public void initSetQuestions(String[] urns) {
		questionItemList.initSetIdentifiableUrns(urns);
	}
	
	protected void setQuestionItemList(
			InitializingSchemeItemList<QuestionItemBean> questionItemList) {
		this.questionItemList = questionItemList;
	}

	@Override
	public InitializingSchemeItemList<QuestionItemBean> getQuestionList() {
		return questionItemList;
	}

	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another) {
		// TODO Auto-generated method stub
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.QuestionScheme;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return QuestionSchemeBean.class;
	}
}
