package org.openmetadata.beans.ddi.lifecycle.datacollection;

import java.util.List;

import org.openmetadata.beans.ddi.lifecycle.adt.SchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.reusable.CodeValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.MaintainableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.SoftwareBean;
import org.openmetadata.ddi_3_1.util.DdiClass;

public interface InstrumentBean extends MaintainableBean {
	
	public final static DdiClass ddiClass = DdiClass.Instrument;

	DynamicTextValueBean getInstructText();

	CodeValueBean getType();
	
	SchemeItemList<SoftwareBean> getSoftwareList();
	
	List<String> getExternalInstrumentLocations();	
	
	boolean isSetControlConstruct();
	
	void setControlConstruct(ControlConstructBean bean);
	
	ControlConstructBean getControlConstruct();
	
	String getControlConstructUrn();
	
	void unsetControlConstruct();
}
