package org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptGroupBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractSchemeItemBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public class ConceptGroupBeanImpl extends
		AbstractSchemeItemBean<ConceptSchemeBean> implements ConceptGroupBean {

	private final ReferenceSetImpl<ConceptBean> conceptRefs;
	private final ReferenceSetImpl<ConceptGroupBean> conceptGroupRefs;
	final private ReferenceBeanImpl<ConceptBean> definingConceptReference;

	public ConceptGroupBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		conceptRefs = new ReferenceSetImpl<ConceptBean>(ConceptBean.class,
				beanInitializer,
				factory, this);
		conceptGroupRefs = new ReferenceSetImpl<ConceptGroupBean>(
				ConceptGroupBean.class, beanInitializer, factory, this);
		definingConceptReference = new ReferenceBeanImpl<ConceptBean>(
				ConceptBean.class, factory, this);
	}

	public void initSetConcepts(String[] conceptUrns) {
		conceptRefs.initReferenceUrns(conceptUrns);
	}

	public void initSetConceptGroups(String[] conceptGroupUrns) {
		conceptGroupRefs.initReferenceUrns(conceptGroupUrns);
	}

	@Override
	public boolean isSetDefiningConcept() {
		return definingConceptReference.isSet();
	}

	@Override
	public void setDefiningConcept(ConceptBean concept)
			 {
		definingConceptReference.setReferenceTo(concept);
	}

	@Override
	public String getDefiningConceptUrn() {
		return definingConceptReference.getUrn();
	}

	@Override
	public ConceptBean getDefiningConcept() {
		try {
			return definingConceptReference.getReferredObject();
		} catch (ResolverException e) {
			return null;
		}
	}

	public ReferenceBeanImpl<ConceptBean> getDefiningConceptReference() {
		return definingConceptReference;
	}

	@Override
	public boolean isDefiningConcepts() {
		return definingConceptReference.isSet();
	}

	@Override
	public boolean isAdministrativePurpose() {
		return definingConceptReference.isSet() == false;
	}

	@Override
	public void setToAdministrativePurpose() {
		definingConceptReference.unset();
		this.change();
	}

	@Override
	public ReferenceSetImpl<ConceptBean> getConceptList() {
		return this.conceptRefs;
	}

	@Override
	public ReferenceSetImpl<ConceptGroupBean> getConceptGroupList() {
		return this.conceptGroupRefs;
	}

	@Override
	protected void doChangeReference(IdentifiableBean toRemove,
			IdentifiableBean toAdd) {
		if (toRemove instanceof ConceptBean && toAdd instanceof ConceptBean) {
			ConceptBean concept = (ConceptBean) toRemove;
			if (this.getConceptList().contains(concept)) {
				this.getConceptList().remove(concept);
				this.getConceptList().add((ConceptBean) toAdd);
			}
		} else if (toRemove instanceof ConceptGroupBean
				&& toAdd instanceof ConceptGroupBean) {
			ConceptGroupBean conceptGroup = (ConceptGroupBean) toRemove;
			if (this.getConceptGroupList().contains(conceptGroup)) {
				this.getConceptGroupList().remove(conceptGroup);
				this.getConceptGroupList().add((ConceptGroupBean) toAdd);
			}
		}
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		if (toRemove instanceof ConceptBean) {
			ConceptBean concept = (ConceptBean) toRemove;
			if (this.getConceptList().contains(concept)) {
				this.getConceptList().remove(concept);
			}
		} else if (toRemove instanceof ConceptGroupBean) {
			ConceptGroupBean conceptGroup = (ConceptGroupBean) toRemove;
			if (this.getConceptGroupList().contains(conceptGroup)) {
				this.getConceptGroupList().remove(conceptGroup);
			}
		}
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.ConceptGroup;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return ConceptGroupBean.class;
	}
}
