package org.openmetadata.beans.ddi.lifecycle.archive;

import org.openmetadata.beans.ddi.lifecycle.adt.DdiBeanList;
import org.openmetadata.beans.ddi.lifecycle.reusable.CodeValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.CountryBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.InternationalStringValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.PointBean;
import org.openmetadata.ddi_3_1.util.DdiClass;

public interface LocationBean extends IdentifiableBean {
	
	public final static DdiClass ddiClass = DdiClass.Location;

	boolean isSetPrivacy();
	void setPrivacy(PrivacyCode code);
	void unsetPrivacy();
	PrivacyCode getPrivacy();	

	
	String getType();

	void setType(String value);

	boolean isSetType();

	InternationalStringValueBean getNickname();

	DdiBeanList<AddressBean> getAddressList();

	CountryBean getCountry();

	DdiBeanList<TelephoneBean> getTelephoneList();

	DdiBeanList<URLBean> getURLList();

	DdiBeanList<EmailBean> getEmailList();

	DdiBeanList<InstantMessagingBean> getInstantMessagingList();

	PointBean getGeographicalLocation();

	CodeValueBean getRegionalCoverage();

}
