/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.impl.ResolvingSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.SchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.LogicalRecordBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.GrossRecordStructureBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.PhysicalRecordSegmentBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractIdentifiableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class GrossRecordStructureBeanImpl
extends AbstractIdentifiableBeanImpl
implements GrossRecordStructureBean {
    private static int DEFAULT_NUMBER_OF_PHYSICAL_SEGEMENTS = 1;
    private Integer numberOfPhysicalSegments = null;
    private ReferenceBeanImpl<LogicalRecordBean> logicalRecordRef;
    private SchemeItemListImpl<PhysicalRecordSegmentBean> physicalRecordSegements;

    public GrossRecordStructureBeanImpl(Boolean isNewInstance, URN urn, MutableBeanInitializer beanInitializer, DdiBeanFactory factory) {
        super(isNewInstance, urn, beanInitializer, factory);
        this.logicalRecordRef = new ReferenceBeanImpl<LogicalRecordBean>(LogicalRecordBean.class, factory, (ChangeListener)this);
        this.physicalRecordSegements = new ResolvingSchemeItemListImpl<PhysicalRecordSegmentBean>(urn.getParent().toString(), PhysicalRecordSegmentBean.class, beanInitializer, factory, (ChangeListener)this);
    }

    public void initSetLogicalRecord(String urn) throws URNFormatException {
        this.logicalRecordRef.setReferenceUrn(urn);
    }

    public void initSetPhysicalRecordSegments(String[] urns) {
        this.physicalRecordSegements.initSetIdentifiableUrns(urns);
    }

    @Override
    public boolean isSetNumberOfPhysicalSegements() {
        return this.numberOfPhysicalSegments != null;
    }

    @Override
    public void setNumberOfPhysicalSegments(int value) {
        this.numberOfPhysicalSegments = value;
        this.change();
    }

    @Override
    public int getNumberOfPhysicalSegments() {
        if (this.numberOfPhysicalSegments != null) {
            return this.numberOfPhysicalSegments;
        }
        return DEFAULT_NUMBER_OF_PHYSICAL_SEGEMENTS;
    }

    public ReferenceBeanImpl<LogicalRecordBean> getLogicalRecordReference() {
        return this.logicalRecordRef;
    }

    @Override
    public String getLogicalRecordUrn() {
        return this.logicalRecordRef.getUrn();
    }

    @Override
    public boolean isSetLogicalRecord() {
        return this.logicalRecordRef.isSet();
    }

    @Override
    public void setLogicalRecord(LogicalRecordBean logicalRecord) {
        this.logicalRecordRef.setReferenceTo(logicalRecord);
    }

    @Override
    public LogicalRecordBean getLogicalRecord() {
        try {
            return this.logicalRecordRef.getReferredObject();
        }
        catch (ResolverException e) {
            return null;
        }
    }

    public SchemeItemListImpl<PhysicalRecordSegmentBean> getPhysicalRecordSegments() {
        return this.physicalRecordSegements;
    }

    @Override
    public void doChangeReference(IdentifiableBean current, IdentifiableBean another) {
    }

    @Override
    protected void doRemoveReference(IdentifiableBean toRemove) {
    }

    @Override
    public DdiClass getDdiClass() {
        return DdiClass.GrossRecordStructure;
    }

    @Override
    public Class<? extends IdentifiableBean> getBeanType() {
        return GrossRecordStructureBean.class;
    }
}

