package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.InternationalStringValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.RelationshipBean;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.notification.ChangeListener;

public class RelationshipBeanImpl extends UnsettableDdiBeanImpl implements
		RelationshipBean {

	private InternationalStringValueBeanImpl relationshipDescription;
	private ReferenceBeanImpl<IdentifiableBean> relatedToReference;

	public RelationshipBeanImpl(DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);
		relationshipDescription = new InternationalStringValueBeanImpl(factory,
				this);		
		relatedToReference = new ReferenceBeanImpl<IdentifiableBean>(
				IdentifiableBean.class, factory, listener);
	}
	
	@Override
	public InternationalStringValueBean getRelationshipDescription() {
		return relationshipDescription;
	}

	@Override
	public void setRelatedToReference(String urn) {
		relatedToReference.setReferenceUrn(urn);
	}

	@Override
	public String getRelatedToReference() {
		return relatedToReference.getUrn();
	}
	
	@Override
	public IdentifiableBean getRelatedToReferenceObject() throws ResolverException {
		return relatedToReference.getReferredObject();		
	}

	@Override
	public boolean internalIsSet() {
		return relatedToReference.isSet();
	}
}
