package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import java.util.Map;

import org.openmetadata.beans.ddi.lifecycle.OpenMetadataKey;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.KeyedBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.LanguageKeyedBean;
import org.openmetadata.beans.notification.ChangeListener;

public class LanguageKeyedBeanImpl extends KeyedBeanImpl implements LanguageKeyedBean{
	
	private static  Map<Enum<?>, Object> createKeyMapWithLanguage(String lang, Map<Enum<?>, Object> keyMap){
		keyMap.put(OpenMetadataKey.LANG, lang);
		return keyMap;
	}
	
	public LanguageKeyedBeanImpl(String language, Map<Enum<?>, Object> keyMap,
			DdiBeanFactory beanFactory, ChangeListener changeListener) {
		super(createKeyMapWithLanguage(language, keyMap), beanFactory, changeListener);
	}

	@Override
	public String getLanguage() {
		return (String) this.getKeyMap().get(OpenMetadataKey.LANG);
	}
	
}
