package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import java.util.Map;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.InternationalStringBean;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public abstract class AbstractInternationalStringBeanImpl extends
		LanguageKeyedBeanImpl implements InternationalStringBean {

	private static boolean TRANSLATABLE_DEFAULT = true;
	private static boolean TRANSLATED_DEFAULT = false;

	private String stringValue = "";

	/* schema default: true */
	private Boolean translatable;

	/* schema default: false */
	private Boolean translated;

	public AbstractInternationalStringBeanImpl(String lang, Map<Enum<?>, Object> keyMap,
			DdiBeanFactory factory, ChangeListener listener) {
		super(lang, keyMap, factory, listener);
	}

	@Override
	public boolean isSetTranslated() {
		return translated != null;
	}

	@Override
	public boolean getTranslated() {
		if (isSetTranslated()) {
			return translated;
		} else {
			return TRANSLATED_DEFAULT;
		}
	}

	@Override
	public void setTranslated(boolean boo) {
		if (CompareUtil.areDifferentValues(translated, boo)) {
			translated = boo;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetTranslatable() {
		return translatable != null;
	}

	@Override
	public boolean getTranslatable() {
		if (isSetTranslatable()) {
			return translatable;
		} else {
			return TRANSLATABLE_DEFAULT;
		}
	}

	@Override
	public void setTranslatable(boolean boo) {
		if (CompareUtil.areDifferentValues(translatable, boo)) {
			translatable = boo;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public String getStringValue() {
		if (stringValue == null) {
			return "";
		} else {
			return stringValue;
		}
	}

	@Override
	public void setStringValue(String value) {
		if (CompareUtil.areDifferentValues(stringValue, value)) {
			stringValue = value;
			populate();
			this.ddiBeanChanged();
		}
	}
	
	@Override
	protected boolean internalIsSet() {
		return !StringUtils.isEmpty(stringValue);
	}

}