package org.openmetadata.beans.ddi.lifecycle.reusable;

import org.openmetadata.beans.exceptions.ResolverException;

public interface RelationshipBean extends UnsettableDdiBean {

	InternationalStringValueBean getRelationshipDescription();

	void setRelatedToReference(String urn);

	/**
	 * Return the related object URN
	 * @return
	 */
	String getRelatedToReference();
	
	/**
	 * Resolve and return the related object
	 * @return
	 * @throws ResolverException
	 */
	IdentifiableBean getRelatedToReferenceObject() throws ResolverException;
}
