package org.openmetadata.beans.ddi.lifecycle.logicalproduct;

import java.util.List;

import org.openmetadata.beans.ddi.lifecycle.adt.DirectedEdge;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.ddi_3_1.util.DdiClass;

public interface RecordRelationshipBean extends IdentifiableBean {

	public final static DdiClass ddiClass = DdiClass.RecordRelationship;

	ValueTypeCode getType();

	void setType(ValueTypeCode type);

	boolean isSetType();

	void setRelation(RelationCode value);

	RelationCode getRelation();

	LogicalRecordBean getSourceLogicalRecord();

	String getSourceLogicalRecordUrn();

	void setSourceLogicalRecordBean(LogicalRecordBean logicalRecord);

	LogicalRecordBean getTargetLogicalRecord();

	String getTargetLogicalRecordUrn();

	void setTargetLogicalRecordBean(LogicalRecordBean logicalRecord);

	void addVariableRelation(VariableBean source, VariableBean target);

	void removeVariableRelation(VariableBean source, VariableBean target);

	void removeAllVariableRelations();

	/**
	 * Return the unbacked list of relations
	 * 
	 * @return
	 */
	List<DirectedEdge<VariableBean>> getVariableRelations();

}
