package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.beans.ddi.lifecycle.datacollection.OriginBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.CitationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CitationBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class OriginBeanImpl extends UnsettableDdiBeanImpl implements OriginBean{
	
	private CitationBean citation;
	private String originLocation;

	public OriginBeanImpl(
			MutableBeanInitializer beanInitializer, 
			DdiBeanFactory beanFactory,
			ChangeListener changeListener) {
		super(beanFactory, changeListener);
		
		citation = new CitationBeanImpl(beanInitializer, beanFactory, this);
	}

	@Override
	public CitationBean getCitation() {
		return citation;
	}

	@Override
	public boolean isSetOriginLocation() {
		return !StringUtils.isEmpty(originLocation);
	}

	@Override
	public String getOriginLocation() {
		return StringUtils.defaultString(originLocation);
	}

	@Override
	public void setOriginLocation(String value) {
		originLocation = value;
	}

	@Override
	public void unsetOriginLocation() {
		originLocation = null;
	}

	@Override
	protected boolean internalIsSet() {
		return citation.isSet() || !StringUtils.isEmpty(originLocation);
	}

}
