package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import java.util.ArrayList;
import java.util.List;

import org.openmetadata.beans.ddi.lifecycle.datacollection.DataAppraisalInformationBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.StructuredStringValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.StructuredStringValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public class DataAppraisalInformationBeanImpl extends UnsettableDdiBeanImpl
		implements DataAppraisalInformationBean {

	private List<String> responseRates;
	private StructuredStringValueBean otherAppraisalProcess;
	private StructuredStringValueBean samplingError;

	public DataAppraisalInformationBeanImpl(DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);

		responseRates = new ArrayList<String>();
		otherAppraisalProcess = new StructuredStringValueBeanImpl(factory, this);
		samplingError = new StructuredStringValueBeanImpl(factory, this);
	}
	
	@Override
	public List<String> getResponseRateList() {
		return responseRates;
	}

	@Override
	public StructuredStringValueBean getOtherAppraisalProcess() {
		return otherAppraisalProcess;
	}

	@Override
	public StructuredStringValueBean getSamplingError() {
		return samplingError;
	}

	@Override
	protected boolean internalIsSet() {
		return responseRates.size()>0 ||
				(otherAppraisalProcess!=null && otherAppraisalProcess.isSet()) ||
				(samplingError!=null && samplingError.isSet());
	}

}
