package org.openmetadata.beans.ddi.lifecycle.archive.impl;

import org.openmetadata.beans.ddi.lifecycle.archive.PrivacyCode;
import org.openmetadata.beans.ddi.lifecycle.archive.URLBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class URLBeanImpl extends UnsettableDdiBeanImpl implements URLBean {

	private String stringValue;
	private PrivacyCode privacyCode;

	public URLBeanImpl(DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		stringValue = null;
	}
	
	@Override
	public boolean isSetPrivacy() {
		return this.privacyCode != null;
	}
	
	@Override
	public void setPrivacy(PrivacyCode code) {
		privacyCode = code;
		this.ddiBeanChanged();
	}
	
	@Override
	public void unsetPrivacy() {
		privacyCode = null;
		this.ddiBeanChanged();
	}
	
	@Override
	public PrivacyCode getPrivacy() {
		if(privacyCode != null){
			return privacyCode;
		}else{
			return PrivacyCode.PUBLIC;
		}
	}

	@Override
	public String getStringValue() {
		return StringUtils.defaultString(stringValue);
	}

	@Override
	public void setStringValue(String value) {
		stringValue = value;
		this.ddiBeanChanged();
	}
	
	@Override
	protected boolean internalIsSet() {
		return !StringUtils.isEmpty(stringValue);
	}
}
