package org.openmetadata.beans.ddi.lifecycle.archive.impl;

import org.openmetadata.beans.ddi.lifecycle.archive.PrivacyCode;
import org.openmetadata.beans.ddi.lifecycle.archive.TelephoneBean;
import org.openmetadata.beans.ddi.lifecycle.archive.TelephoneTypeCode;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class TelephoneBeanImpl extends UnsettableDdiBeanImpl implements
		TelephoneBean {

	private String stringValue;
	private PrivacyCode privacyCode;
	private TelephoneTypeCode type;

	public TelephoneBeanImpl(DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		stringValue = null;
	}	

	@Override
	public boolean isSetPrivacy() {
		return this.privacyCode != null;
	}
	
	@Override
	public void setPrivacy(PrivacyCode code) {
		privacyCode = code;
		this.ddiBeanChanged();
	}
	
	@Override
	public void unsetPrivacy() {
		privacyCode = null;
		this.ddiBeanChanged();
	}
	
	@Override
	public PrivacyCode getPrivacy() {
		if(privacyCode != null){
			return privacyCode;
		}else{
			return PrivacyCode.PUBLIC;
		}
	}
	
	@Override
	public boolean isSetType() {
		return this.type != null;
	}

	@Override
	public void setType(TelephoneTypeCode type) {
		this.type = type;
		this.ddiBeanChanged();
	}
	
	@Override
	public void unsetType() {
		this.type = null;
		this.ddiBeanChanged();
	}
	
	@Override
	public TelephoneTypeCode getType() {
		if(this.type != null){
			return this.type;
		}else{
			return TelephoneTypeCode.HOME;
		}
	}
	
	@Override
	public String getStringValue() {
		return StringUtils.defaultString(stringValue);
	}

	@Override
	public void setStringValue(String value) {
		stringValue = value;
		this.ddiBeanChanged();
	}
	
	@Override
	protected boolean internalIsSet() {
		return !StringUtils.isEmpty(stringValue);
	}
}
