package org.openmetadata.beans.ddi.lifecycle.adt;

import java.util.Comparator;

import org.openmetadata.beans.ddi.lifecycle.reusable.DdiBean;

public interface DdiBeanList<B extends DdiBean> extends DdiBean, Iterable<B> {

	public B addNew();

	boolean contains(B bean);

	boolean remove(B bean);
	
	int size();

	void moveBefore(B move, B before);

	void moveAfter(B move, B after);
	
	void sort(Comparator<B> comparator);

	B[] toArray();
}
