package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import java.util.Map;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.LabelBean;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class LabelBeanImpl extends AbstractStructuredStringBeanImpl implements
		LabelBean {

	public LabelBeanImpl(String lang, Map<Enum<?>, Object> keyMap,
			DdiBeanFactory factory,
			ChangeListener listener) {
		super(lang, keyMap, factory, listener);
	}

	private String locationVariant;
	private String type;
	private Integer maxLength;

	@Override
	public boolean isSetLocationVariant() {
		return locationVariant != null;
	}

	@Override
	public String getLocationVariant() {
		return StringUtils.defaultString(locationVariant);
	}

	@Override
	public void setLocationVariant(String value) {
		if (CompareUtil.areDifferentValues(this.locationVariant, value)) {
			this.locationVariant = value;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetType() {
		return type != null;
	}

	@Override
	public String getType() {
		return StringUtils.defaultString(type);
	}

	@Override
	public void setType(String value) {
		if (CompareUtil.areDifferentValues(this.type, value)) {
			this.type = value;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetMaxLength() {
		return maxLength != null;
	}

	@Override
	public int getMaxLength() {
		if (maxLength != null) {
			return maxLength.intValue();
		} else {
			return 0;
		}
	}

	@Override
	public void setMaxLength(int value) {
		if (CompareUtil.areDifferentValues(this.maxLength, value)) {
			maxLength = new Integer(value);
			populate();
			this.ddiBeanChanged();
		}
	}

	/*
	 * @Override public LabelType getDdi3XmlObject() throws
	 * DdiValidationException { LabelType lt = super.getDdi3XmlObject(); if
	 * (isSetType()) { lt.setType(getType()); }else if (lt.isSetType()) {
	 * lt.unsetType(); }
	 * 
	 * if (isSetLocationVariant()) {
	 * lt.setLocationVariant(getLocationVariant()); }else if
	 * (lt.isSetLocationVariant()) { lt.unsetLocationVariant(); }
	 * 
	 * if (isSetValidForDate()) { lt.setValidForDate(getValidForDate()); }else
	 * if (lt.isSetValidForDate()) { lt.unsetValidForDate(); }
	 * 
	 * if (isSetMaxLength()) {
	 * lt.setMaxLength(BigInteger.valueOf(getMaxLength())); }else if
	 * (lt.isSetMaxLength()) { lt.unsetMaxLength(); }
	 * 
	 * return lt; }
	 * 
	 * @Override protected LabelType createDdi3XmlObject() { return
	 * LabelType.Factory.newInstance(); }
	 * 
	 * @Override protected SchemaType getSchemaType() { return LabelType.type; }
	 * 
	 * @Override protected Class<? extends LabelType> getDdi3XmlObjectClass() {
	 * return LabelType.class; }
	 */

}
