package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import java.util.Map;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.CreatorBean;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class CreatorBeanImpl extends AbstractInternationalStringBeanImpl
		implements CreatorBean {

	private String affiliation;

	public CreatorBeanImpl(String lang, Map<Enum<?>, Object> keyMap,
			DdiBeanFactory factory,
			ChangeListener listener) {
		super(lang, keyMap, factory, listener);
	}

	@Override
	public boolean isSetAffiliation() {
		return affiliation != null && (!affiliation.isEmpty());
	}

	@Override
	public String getAffiliation() {
		return StringUtils.defaultString(affiliation);
	}

	@Override
	public void setAffiliation(String value) {
		if (CompareUtil.areDifferentValues(this.affiliation, value)) {
			this.affiliation = value;
			this.ddiBeanChanged();
		}
	}
}
