package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import java.util.Map;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.ContributorBean;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class ContributorBeanImpl extends AbstractInternationalStringBeanImpl
		implements ContributorBean {

	private String affiliation;
	private String role;

	public ContributorBeanImpl(String lang, Map<Enum<?>, Object> keyMap,
			DdiBeanFactory factory,
			ChangeListener listener) {
		super(lang, keyMap, factory, listener);
	}

	@Override
	public boolean isSetAffiliation() {
		return affiliation != null && (!affiliation.isEmpty());
	}

	@Override
	public String getAffiliation() {
		return StringUtils.defaultString(affiliation);
	}

	@Override
	public void setAffiliation(String affiliation) {
		if (CompareUtil.areDifferentValues(this.affiliation, affiliation)) {
			this.affiliation = affiliation;
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetRole() {
		return role != null && (!role.isEmpty());
	}

	@Override
	public void setRole(String value) {
		if (CompareUtil.areDifferentValues(this.role, value)) {
			role = value;
			this.ddiBeanChanged();
		}
	}

	@Override
	public String getRole() {
		return StringUtils.defaultString(role);
	}

	/*
	 * @Override public ContributorType getDdi3XmlObject() throws
	 * DdiValidationException { ContributorType ct = super.getDdi3XmlObject();
	 * if(this.isSetAffiliation()){ ct.setAffiliation(getAffiliation()); }else
	 * if (ct.isSetAffiliation()) { ct.unsetAffiliation(); }
	 * 
	 * if(this.isSetRole()){ ct.setRole(getRole()); }else if (ct.isSetRole()) {
	 * ct.unsetRole(); } return ct; }
	 */

	/*
	 * @Override protected ContributorType createDdi3XmlObject() { return
	 * ContributorType.Factory.newInstance(); }
	 * 
	 * @Override protected SchemaType getSchemaType() { return
	 * ContributorType.type; }
	 */
}
