package org.openmetadata.beans.ddi.lifecycle.physicalinstance.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.CategoryStatisticBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CodeValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public class CategoryStatisticBeanImpl extends UnsettableDdiBeanImpl implements
		CategoryStatisticBean {

	CodeValueBeanImpl categoryStatType;
	boolean weighted;
	double value;
	FilterBeanImpl filter;

	public CategoryStatisticBeanImpl(DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);

		categoryStatType = new CodeValueBeanImpl(factory, this);
		weighted = false;
		value = 0;
		filter = new FilterBeanImpl(factory, this);
	}

	@Override
	public CodeValueBeanImpl getCategoryStatisticType() {
		return categoryStatType;
	}

	@Override
	public boolean getIsWeighted() {
		return weighted;
	}

	@Override
	public double getValue() {
		return value;
	}

	@Override
	public FilterBeanImpl getFilter() {
		if (filter == null) {
			filter = new FilterBeanImpl(this.getBeanFactory(), this);
		}
		return filter;
	}
	
	@Override
	protected boolean internalIsSet() {
		return categoryStatType.isSet() || filter.isSet();
	}
}
