package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableGroupBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.CodeValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractSchemeItemBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CodeValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public class VariableGroupBeanImpl extends
		AbstractSchemeItemBean<VariableSchemeBean> implements VariableGroupBean {

	final ReferenceBeanImpl<ConceptBean> conceptRef;
	final ReferenceSetImpl<UniverseBean> universeRefs;
	final ReferenceSetImpl<VariableBean> variableRefs;
	final ReferenceSetImpl<VariableGroupBean> variableGroupRefs;

	final CodeValueBeanImpl groupType;

	public VariableGroupBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		conceptRef = new ReferenceBeanImpl<ConceptBean>(ConceptBean.class,
				factory, this);
		universeRefs = new ReferenceSetImpl<UniverseBean>(UniverseBean.class, beanInitializer,
				factory, this);
		variableRefs = new ReferenceSetImpl<VariableBean>(VariableBean.class, beanInitializer,
				factory, this);
		variableGroupRefs = new ReferenceSetImpl<VariableGroupBean>(
				VariableGroupBean.class, beanInitializer, factory, this);

		groupType = new CodeValueBeanImpl(factory, this);
	}

	public void initSetConcept(String urn) throws URNFormatException {
		conceptRef.setReferenceUrn(urn);
	}

	public void initSetUniverses(String[] urns) {
		universeRefs.initReferenceUrns(urns);
	}

	public void initSetVariables(String[] urns) {
		variableRefs.initReferenceUrns(urns);
	}

	public void initSetVariableGroups(String[] urns) {
		variableGroupRefs.initReferenceUrns(urns);
	}

	@Override
	public CodeValueBean getGroupType() {
		return groupType;
	}

	@Override
	public ReferenceSetImpl<UniverseBean> getUniverseList() {
		return universeRefs;
	}

	@Override
	public String getConceptUrn() {
		return conceptRef.getUrn();
	}

	@Override
	public boolean isSetConcept() {
		return this.conceptRef.isSet();
	}

	@Override
	public void setConcept(ConceptBean concept)  {
		this.conceptRef.setReferenceTo(concept);
	}

	@Override
	public ConceptBean getConcept() {
		if (this.isSetConcept()) {
			try {
				return this.conceptRef.getReferredObject();
			} catch (ResolverException e) {
				return null;
			}
		} else {
			return null;
		}
	}

	@Override
	public ReferenceSetImpl<VariableBean> getVariableList() {
		return variableRefs;
	}

	@Override
	public ReferenceSetImpl<VariableGroupBean> getVariableGroupList() {
		return variableGroupRefs;
	}

	@Override
	protected void doChangeReference(IdentifiableBean current,
			IdentifiableBean another)  {

		if (current instanceof ConceptBean && another instanceof ConceptBean) {
			ConceptBean currConcept = (ConceptBean) current;
			if (this.conceptRef.isReferring(currConcept)) {
				ConceptBean anotherConcept = (ConceptBean) another;
				this.conceptRef.setReferenceTo(anotherConcept);
			}
		} else if (current instanceof UniverseBean
				&& another instanceof UniverseBean) {
			UniverseBean currUniverse = (UniverseBean) current;
			if (this.universeRefs.contains(currUniverse)) {
				this.universeRefs.remove(currUniverse.getUrn());

				UniverseBean anotherUniverse = (UniverseBean) another;
				this.universeRefs.add(anotherUniverse);
			}
		} else if (current instanceof VariableBean
				&& another instanceof VariableBean) {
			VariableBean curVariable = (VariableBean) current;
			if (this.variableRefs.contains(curVariable)) {
				this.variableRefs.remove(curVariable);

				VariableBean anotherVariable = (VariableBean) another;
				this.variableRefs.add(anotherVariable);
			}
		} else if (current instanceof VariableGroupBean
				&& another instanceof VariableGroupBean) {
			VariableGroupBean curVarGroup = (VariableGroupBean) current;
			if (this.variableGroupRefs.contains(curVarGroup)) {
				this.variableGroupRefs.remove(curVarGroup);

				VariableGroupBean anotherVarGroup = (VariableGroupBean) another;
				this.variableGroupRefs.add(anotherVarGroup);
			}
		}
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		if (toRemove instanceof ConceptBean) {
			ConceptBean currConcept = (ConceptBean) toRemove;
			if (this.conceptRef.isReferring(currConcept)) {
				this.conceptRef.unset();
			}
		} else if (toRemove instanceof UniverseBean) {
			UniverseBean currUniverse = (UniverseBean) toRemove;
			if (this.universeRefs.contains(currUniverse)) {
				this.universeRefs.remove(currUniverse.getUrn());
			}
		} else if (toRemove instanceof VariableBean) {
			VariableBean curVariable = (VariableBean) toRemove;
			if (this.variableRefs.contains(curVariable)) {
				this.variableRefs.remove(curVariable);
			}
		} else if (toRemove instanceof VariableGroupBean) {
			VariableGroupBean curVarGroup = (VariableGroupBean) toRemove;
			if (this.variableGroupRefs.contains(curVarGroup)) {
				this.variableGroupRefs.remove(curVarGroup);
			}
		}
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.VariableGroup;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return VariableGroupBean.class;
	}
}
