package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.IntervalBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public class IntervalBeanImpl extends UnsettableDdiBeanImpl implements IntervalBean {
	
	private String anchor;
	private String increment;

	public IntervalBeanImpl(DdiBeanFactory beanFactory,
			ChangeListener changeListener) {
		super(beanFactory, changeListener);
	}

	@Override
	public String getAnchor() {
		return StringUtils.defaultString(this.anchor);
	}

	@Override
	public void setAnchor(String value) {
		this.anchor = value;
		this.ddiBeanChanged();
	}

	@Override
	public String getIncrement() {
		return StringUtils.defaultString(this.increment);
	}

	@Override
	public void setIncrement(String value) {
		this.increment = value;
		this.ddiBeanChanged();
	}

	@Override
	protected boolean internalIsSet() {
		return this.anchor!=null || this.increment!=null;
	}

}
