package org.openmetadata.beans.ddi.lifecycle.group;

import org.openmetadata.beans.ddi.lifecycle.adt.SchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.ReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.archive.ArchiveBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptualComponentBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.DataCollectionBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.LogicalProductBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.PhysicalDataProductBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.CitationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.CoverageBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiedStructuredStringValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NoteBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.OtherMaterialBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.SeriesStatementBean;
import org.openmetadata.beans.ddi.lifecycle.studyunit.StudyUnitBean;

interface BaseGroup {
		

	boolean isSetUserDefinedGroupProperty();
	String getUserDefinedGroupProperty();
	void setUserDefinedGroupProperty(String value);
	void unsetUserDefinedGroupProperty();
	
	boolean isSetUserDefinedGroupPropertyValue();
	String getUserDefinedGroupPropertyValue();
	void setUserDefinedGroupPropertyValue(String value);
	void unsetUserDefinedGroupPropertyValue();
	
	boolean isSetGroupInherits();
	boolean getGroupInherits();
	void setGroupInherits(boolean boo);
	void unsetGroupInherits();
	
	CitationBean getCitation();
	
	IdentifiedStructuredStringValueBean getAbstract();
	
	IdentifiedStructuredStringValueBean getPurpose();
	
	SeriesStatementBean getSeriesStatement();
	
	//TODO FundingInformationBean getFundingInformation();
	
	CoverageBean getCoverage();
	
	boolean isSetUniverse();
	UniverseBean getUniverse();
	String getUniverseUrn();
	void setUniverse(UniverseBean universe);
	void unsetUniverse();
	
	SchemeItemList<OtherMaterialBean> getOtherMaterialList();
	
	boolean isSetArchive();
	ArchiveBean getArchive();
	String getArchiveUrn();
	void setArchive(ArchiveBean archive);
	void unsetArchive();
	
	SchemeItemList<NoteBean> getNoteList();	
	
	ReferenceSet<ConceptualComponentBean> getConceptualComponentList();
	
	ReferenceSet<DataCollectionBean> getDataCollectionList();
	
	ReferenceSet<LogicalProductBean> getLogicalProductList();
	
	ReferenceSet<PhysicalDataProductBean> getPhysicalDataProductList();
	
	ReferenceSet<StudyUnitBean> getStudyUnitList();
	
	SchemeItemList<SubGroupBean> getSubGroupList();
	
	//TODO Comparison getComparison();
	
	//TODO ReferenceSet<DDIProfileBean> getDdiProfileList();
}
