package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionConstructBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionItemBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public class QuestionConstructBeanImpl extends ControlConstructBeanImpl
		implements QuestionConstructBean {

	private final ReferenceBeanImpl<QuestionItemBean> questionReference;
	private final ReferenceSetImpl<UniverseBean> uniRefSet;

	public QuestionConstructBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		questionReference = new ReferenceBeanImpl<QuestionItemBean>(
				QuestionItemBean.class, factory, this);
		uniRefSet = new ReferenceSetImpl<UniverseBean>(UniverseBean.class,
				beanInitializer,
				factory, this);
	}

	public void initSetQuestion(String questionItemUrn)
			throws URNFormatException {
		questionReference.setReferenceUrn(questionItemUrn);
	}

	public void initSetUniverses(String[] universeUrns) {
		uniRefSet.initReferenceUrns(universeUrns);
	}

	public ReferenceBeanImpl<QuestionItemBean> getQuestionReference() {
		return questionReference;
	}

	@Override
	public boolean isSetQuestion() {
		return questionReference.isSet();
	}

	@Override
	public void setQuestion(QuestionItemBean question)
		 {
		questionReference.setReferenceTo(question);
	}

	@Override
	public String getQuestionUrn() {
		return questionReference.getUrn();
	}

	@Override
	public QuestionItemBean getQuestion() {
		try {
			return questionReference.getReferredObject();
		} catch (ResolverException e) {
			return null;
		}
	}

	@Override
	public ReferenceSetImpl<UniverseBean> getUniverseList() {
		return uniRefSet;
	}

	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another)  {
		super.doChangeReference(current, another);

		if (current instanceof UniverseBean && another instanceof UniverseBean) {
			UniverseBean currUniverse = (UniverseBean) current;
			if (this.uniRefSet.contains(currUniverse)) {
				this.uniRefSet.remove(currUniverse);
				UniverseBean anotherUniverse = (UniverseBean) another;
				this.uniRefSet.add(anotherUniverse);
			}
		}
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		super.doRemoveReference(toRemove);

		if (toRemove instanceof UniverseBean) {
			UniverseBean currUniverse = (UniverseBean) toRemove;
			if (this.uniRefSet.contains(currUniverse)) {
				this.uniRefSet.remove(currUniverse);
			}
		}
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.QuestionConstruct;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return QuestionConstructBean.class;
	}
}
