package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.DdiBeanList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ResolvingSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.CodingBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.DataAppraisalInformationBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.OperationBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ProcessingBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiedStructuredStringValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractIdentifiableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.IdentifiedStructuredStringValueBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class ProcessingBeanImpl extends AbstractIdentifiableBeanImpl implements ProcessingBean{
	
	private DdiBeanList<OperationBean> controlOperationList;
	private DdiBeanList<OperationBean> cleaningOperationList;
	private IdentifiedStructuredStringValueBean weighting;
	private DdiBeanList<DataAppraisalInformationBean> dataAppraisalInfoList;
	private ResolvingSchemeItemListImpl<CodingBean> codingList;

	public ProcessingBeanImpl(Boolean isNewInstance, URN urn,
			final MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory) {
		super(isNewInstance, urn, beanInitializer, beanFactory);
		
		controlOperationList = new DdiBeanListImpl<OperationBean>(OperationBean.class, beanInitializer, beanFactory, this){
			@Override
			protected OperationBean createNew() {
				return new OperationBeanImpl(ProcessingBeanImpl.this,
						beanInitializer,
						ProcessingBeanImpl.this.getBeanFactory(),
						ProcessingBeanImpl.this);
			}
		};
		
		cleaningOperationList = new DdiBeanListImpl<OperationBean>(OperationBean.class, beanInitializer, beanFactory, this){
			@Override
			protected OperationBean createNew() {
				return new OperationBeanImpl(ProcessingBeanImpl.this, beanInitializer,
						ProcessingBeanImpl.this.getBeanFactory(),
						ProcessingBeanImpl.this);
			}
		};
		
		weighting = new IdentifiedStructuredStringValueBeanImpl(beanFactory, this);
		
		dataAppraisalInfoList = new DdiBeanListImpl<DataAppraisalInformationBean>(DataAppraisalInformationBean.class, beanInitializer, beanFactory, this){
			protected DataAppraisalInformationBean createNew() {
				return new DataAppraisalInformationBeanImpl(
						ProcessingBeanImpl.this.getBeanFactory(),
						ProcessingBeanImpl.this);
			}
		};
		
		codingList = new ResolvingSchemeItemListImpl<CodingBean>(
				urn.getParent().toString(), CodingBean.class, beanInitializer, beanFactory, this);
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.Processing;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return ProcessingBean.class;
	}

	@Override
	public DdiBeanList<OperationBean> getControlOperationList() {
		return controlOperationList;
	}

	@Override
	public DdiBeanList<OperationBean> getCleaningOperationList() {
		return cleaningOperationList;
	}

	@Override
	public IdentifiedStructuredStringValueBean getWeighting() {
		return weighting;
	}

	@Override
	public DdiBeanList<DataAppraisalInformationBean> getDataAppraisalInformationList() {
		return dataAppraisalInfoList;
	}
	
	@Override
	public ResolvingSchemeItemListImpl<CodingBean> getCodingList() {
		return codingList;
	}

	@Override
	protected void doChangeReference(IdentifiableBean toRemove,
			IdentifiableBean toAdd) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
		
	}

}
