package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.InitializingSchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.InlineSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.CollectionEventBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ControlConstructSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.DataCollectionBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.InstrumentBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.InterviewerInstructionSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.MethodologyBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ProcessingBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NoteBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.OtherMaterialBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.StructuredStringValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CoverageBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.OtherMaterialBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.StructuredStringValueBeanImpl;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.exceptions.FactoryException;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public class DataCollectionBeanImpl extends AbstractMaintainableBeanImpl
		implements DataCollectionBean {

	private CoverageBeanImpl coverage;
	private MethodologyBeanImpl methodology;
	
	private InitializingSchemeItemList<OtherMaterialBean> otherMatList;
	private InitializingSchemeItemList<NoteBean> noteBeanList;
	private InitializingSchemeItemList<CollectionEventBean> collEventList;
	private InitializingSchemeItemList<ProcessingBean> procEventList;

	private ReferenceSetImpl<QuestionSchemeBean> questionSchemes;
	private ReferenceSetImpl<ControlConstructSchemeBean> controlConstructSchemes;
	private ReferenceSetImpl<InterviewerInstructionSchemeBean> instructionSchemes;
	private ReferenceSetImpl<InstrumentBean> instruments;
	
	private StructuredStringValueBeanImpl errorDetection;
	private StructuredStringValueBeanImpl imputation;
	private StructuredStringValueBeanImpl estimation;
	private StructuredStringValueBeanImpl qualityEvaluation;
	private StructuredStringValueBeanImpl dataAccuracy;
	private StructuredStringValueBeanImpl disclosureControl;
	
	public DataCollectionBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);		

		questionSchemes = new ReferenceSetImpl<QuestionSchemeBean>(
				QuestionSchemeBean.class, beanInitializer, factory, this);
		controlConstructSchemes = new ReferenceSetImpl<ControlConstructSchemeBean>(
				ControlConstructSchemeBean.class, beanInitializer, factory, this);
		instructionSchemes = new ReferenceSetImpl<InterviewerInstructionSchemeBean>(
				InterviewerInstructionSchemeBean.class, beanInitializer, factory, this);
		instruments = new ReferenceSetImpl<InstrumentBean>(
				InstrumentBean.class, beanInitializer, factory, this);
		coverage = new CoverageBeanImpl(beanInitializer, factory, this);

		otherMatList = new InlineSchemeItemListImpl<OtherMaterialBean>(
				urn.toString(), OtherMaterialBean.class, beanInitializer, factory, this);
		noteBeanList = new InlineSchemeItemListImpl<NoteBean>(
				urn.toString(), NoteBean.class, beanInitializer, factory, this);

		collEventList = new InlineSchemeItemListImpl<CollectionEventBean>(
				urn.toString(), CollectionEventBean.class, beanInitializer, factory, this);

		procEventList = new InlineSchemeItemListImpl<ProcessingBean>(
				urn.toString(), ProcessingBean.class, beanInitializer, factory, this);
		
		errorDetection = new StructuredStringValueBeanImpl(factory, this);
		imputation = new StructuredStringValueBeanImpl(factory, this);
		estimation = new StructuredStringValueBeanImpl(factory, this);
		qualityEvaluation = new StructuredStringValueBeanImpl(factory, this);
		dataAccuracy = new StructuredStringValueBeanImpl(factory, this);
		disclosureControl = new StructuredStringValueBeanImpl(factory, this);
	}

	public void initSetQuestionSchemes(String[] urns) {
		questionSchemes.initReferenceUrns(urns);
	}

	public void initSetControlConstructSchemes(String[] urns) {
		controlConstructSchemes.initReferenceUrns(urns);
	}

	public void initSetInstructionSchemes(String[] urns) {
		instructionSchemes.initReferenceUrns(urns);
	}

	public void initSetInstruments(String[] urns) {
		instruments.initReferenceUrns(urns);
	}
	
	public void initSetNotes(String[] urns){
		noteBeanList.initSetIdentifiableUrns(urns);
	}

	public MethodologyBeanImpl initSetMethodolody(String urn) throws URNFormatException {
		URN urnObj = URN.getURN(urn);
		methodology = new MethodologyBeanImpl(false, urnObj, this.getBeanInitializer(), getBeanFactory());
		return methodology;
	}

	public OtherMaterialBean initAddOtherMaterial(String urn)
			throws URNFormatException {
		URN urnObj = URN.getURN(urn);
		OtherMaterialBean otherMat = new OtherMaterialBeanImpl(false, urnObj,
				this.getBeanInitializer(),
				getBeanFactory());
		otherMatList.initAddIdentifiableBean(otherMat);
		return otherMat;
	}

	public CollectionEventBean initAddCollectionEvent(String urn)
			throws URNFormatException {
		URN urnObj = URN.getURN(urn);
		CollectionEventBean collEvent = new CollectionEventBeanImpl(false,
				urnObj, this.getBeanInitializer(), getBeanFactory());
		collEventList.initAddIdentifiableBean(collEvent);
		return collEvent;
	}

	public ProcessingBeanImpl initAddProcessingEvent(String urn)
			throws URNFormatException {
		URN urnObj = URN.getURN(urn);
		ProcessingBeanImpl procEvent = new ProcessingBeanImpl(false, urnObj,
				this.getBeanInitializer(),
				getBeanFactory());
		procEventList.initAddIdentifiableBean(procEvent);
		return procEvent;
	}
	
	@Override
	public StructuredStringValueBeanImpl getErrorDetection(){
		return errorDetection;
	}

	@Override
	public StructuredStringValueBeanImpl getImputation(){
		return imputation;
	}

	@Override
	public StructuredStringValueBeanImpl getEstimation(){
		return estimation;
	}
	
	@Override
	public StructuredStringValueBeanImpl getQualityEvaluation(){
		return qualityEvaluation;
	}
	
	@Override
	public StructuredStringValueBeanImpl getDataAccuracy(){
		return dataAccuracy;
	}
	
	@Override
	public StructuredStringValueBeanImpl getDisclosureControl() {
		return disclosureControl;
	}

	@Override
	public CoverageBeanImpl getCoverage() {
		return coverage;
	}

	@Override
	public InitializingSchemeItemList<OtherMaterialBean> getOtherMaterialList() {
		return otherMatList;
	}

	@Override
	public InitializingSchemeItemList<NoteBean> getNoteList() {
		return noteBeanList;
	}

	/*@Override
	public MethodologyBean getMethodology() {
		if (methodology == null) {
			return new NullMethodologyBeanImpl() {				
				@Override
				protected MethodologyBean getRealBean() {
					try {
						methodology = (MethodologyBeanImpl) getBeanFactory()
								.newInstance(MethodologyBean.class, this.getUrn());
						return methodology;
					} catch (FactoryException e) {
						throw new RuntimeException(e);
					}					
				}
			};
		}
		return methodology;
	}*/
	
	@Override
	public MethodologyBeanImpl addNewMethodology() {
		if (methodology == null) {
			try {
				methodology = (MethodologyBeanImpl) getBeanFactory()
						.newInstance(MethodologyBean.class, this.getUrn());
				return methodology;
			} catch (FactoryException e) {
				throw new RuntimeException(e);
			}	
		}
		return methodology;
	}
	
	@Override
	public MethodologyBeanImpl getMethodology() {
		if (methodology != null) {
			return methodology;
		}else{
			return null;
		}
	}

	@Override
	public InitializingSchemeItemList<CollectionEventBean> getCollectionEventList() {
		return collEventList;
	}

	@Override
	public ReferenceSetImpl<QuestionSchemeBean> getQuestionSchemeList() {
		return questionSchemes;
	}

	@Override
	public ReferenceSetImpl<ControlConstructSchemeBean> getControlConstructSchemeList() {
		return controlConstructSchemes;
	}

	@Override
	public ReferenceSetImpl<InterviewerInstructionSchemeBean> getInterviewInstructionSchemeList() {
		return instructionSchemes;
	}

	@Override
	public ReferenceSetImpl<InstrumentBean> getInstrumentList() {
		return instruments;
	}
	
	protected void setProcessingEventList(
			InitializingSchemeItemList<ProcessingBean> procEventList) {
		this.procEventList = procEventList;
	}

	@Override
	public InitializingSchemeItemList<ProcessingBean> getProcessingEventList() {
		return procEventList;
	}

	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another) {
		if (current instanceof QuestionSchemeBean
				&& another instanceof QuestionSchemeBean) {
			this.getQuestionSchemeList().remove((QuestionSchemeBean) current);
			this.getQuestionSchemeList().add((QuestionSchemeBean) another);

		} else if (current instanceof ControlConstructSchemeBean
				&& another instanceof ControlConstructSchemeBean) {
			this.getControlConstructSchemeList().remove(
					(ControlConstructSchemeBean) current);
			this.getControlConstructSchemeList().add(
					(ControlConstructSchemeBean) another);

		} else if (current instanceof InterviewerInstructionSchemeBean
				&& another instanceof InterviewerInstructionSchemeBean) {
			this.getInterviewInstructionSchemeList().remove(
					(InterviewerInstructionSchemeBean) current);
			this.getInterviewInstructionSchemeList().add(
					(InterviewerInstructionSchemeBean) another);
		}
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		if (toRemove instanceof QuestionSchemeBean) {
			this.getQuestionSchemeList().remove((QuestionSchemeBean) toRemove);

		} else if (toRemove instanceof ControlConstructSchemeBean) {
			this.getControlConstructSchemeList().remove(
					(ControlConstructSchemeBean) toRemove);

		} else if (toRemove instanceof InterviewerInstructionSchemeBean) {
			this.getInterviewInstructionSchemeList().remove(
					(InterviewerInstructionSchemeBean) toRemove);
		}
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.DataCollection;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return DataCollectionBean.class;
	}

	@Override
	public boolean isSetMethodology() {
		return this.methodology != null;
	}

	@Override
	public String getMethodologyUrn() {
		if (this.methodology != null) {
			return this.methodology.getUrn();
		} else {
			return "";
		}
	}

	/*@Override
	public void setMethodology(MethodologyBean bean) {
		if (this.methodology != bean) {
			this.methodology = (MethodologyBeanImpl) bean;
			this.change();
		}
	}*/

	@Override
	public void unsetMethodology() {
		if (this.methodology != null) {
			this.methodology = null;
			this.change();
		}
	}	
}
