package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.DdiBeanList;
import org.openmetadata.beans.ddi.lifecycle.adt.ReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.archive.OrganizationBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.CollectionEventBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.DataCollectionFrequencyBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.DataSourceBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.DateBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiedStructuredStringValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractIdentifiableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.DateBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.IdentifiedStructuredStringValueBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public class CollectionEventBeanImpl extends AbstractIdentifiableBeanImpl implements CollectionEventBean{
	
	private ReferenceSetImpl<OrganizationBean> organizationRefSet;
	private DdiBeanList<DataSourceBean> dataSourceList;
	private DateBean dateBean;
	private DdiBeanList<DataCollectionFrequencyBean> dataCollFrequenceyList;
	
	private IdentifiedStructuredStringValueBean modeOfCollection;
	private IdentifiedStructuredStringValueBean collectionSituation;
	private IdentifiedStructuredStringValueBean actionToMinimizeLosses;

	public CollectionEventBeanImpl(Boolean isNewInstance, URN urn,
			final MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory) {
		super(isNewInstance, urn, beanInitializer, beanFactory);
		
		organizationRefSet = new ReferenceSetImpl<OrganizationBean>(
				OrganizationBean.class, beanInitializer, beanFactory, this);
		
		dataSourceList = new DdiBeanListImpl<DataSourceBean>(DataSourceBean.class, beanInitializer, beanFactory, this){
			@Override
			protected DataSourceBean createNew() {
				return new DataSourceBeanImpl(
						beanInitializer,
						CollectionEventBeanImpl.this.getBeanFactory(), 
						CollectionEventBeanImpl.this);
			}
		};
		
		dateBean = new DateBeanImpl(beanInitializer, beanFactory, this);
		
		dataCollFrequenceyList = new DdiBeanListImpl<DataCollectionFrequencyBean>(DataCollectionFrequencyBean.class, beanInitializer, beanFactory, this){
			protected DataCollectionFrequencyBean createNew() {
				return new DataCollectionFrequencyBeanImpl(
						beanInitializer,
						CollectionEventBeanImpl.this.getBeanFactory(), 
						CollectionEventBeanImpl.this);
			};
		};
		
		modeOfCollection = new IdentifiedStructuredStringValueBeanImpl(beanFactory, this);
		collectionSituation = new IdentifiedStructuredStringValueBeanImpl(beanFactory, this);
		actionToMinimizeLosses = new IdentifiedStructuredStringValueBeanImpl(beanFactory, this);
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.CollectionEvent;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return CollectionEventBean.class;
	}

	@Override
	public ReferenceSet<OrganizationBean> getOrganizations() {
		return organizationRefSet;
	}

	@Override
	public DdiBeanList<DataSourceBean> getDataSourceList() {
		return dataSourceList;
	}

	@Override
	public DateBean getDataCollectionDate() {
		return dateBean;
	}

	@Override
	public DdiBeanList<DataCollectionFrequencyBean> getDataCollectionFrequncyList() {
		return dataCollFrequenceyList;
	}

	@Override
	public IdentifiedStructuredStringValueBean getModeOfCollection() {
		return modeOfCollection;
	}

	@Override
	public IdentifiedStructuredStringValueBean getCollectionSituation() {
		return collectionSituation;
	}

	@Override
	public IdentifiedStructuredStringValueBean getActionToMinimizeLosses() {
		return actionToMinimizeLosses;
	}

	@Override
	protected void doChangeReference(IdentifiableBean toRemove,
			IdentifiableBean toAdd) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
		
	}	

}
