package org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptualComponentBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public class ConceptualComponentBeanImpl extends AbstractMaintainableBeanImpl
		implements ConceptualComponentBean {

	private ReferenceSetImpl<ConceptSchemeBean> conceptSchemeList;
	private ReferenceSetImpl<UniverseSchemeBean> universeSchemeList;

	public ConceptualComponentBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		conceptSchemeList = new ReferenceSetImpl<ConceptSchemeBean>(
				ConceptSchemeBean.class, beanInitializer, factory, this);
		universeSchemeList = new ReferenceSetImpl<UniverseSchemeBean>(
				UniverseSchemeBean.class, beanInitializer, factory, this);
	}

	public void initSetConceptSchemes(String[] conceptSchemeUrns) {
		conceptSchemeList.initReferenceUrns(conceptSchemeUrns);
	}

	public void initSetUniverseSchemes(String[] universeSchemeUrns) {
		universeSchemeList.initReferenceUrns(universeSchemeUrns);
	}

	@Override
	public ReferenceSetImpl<UniverseSchemeBean> getUniverseSchemeList() {
		return universeSchemeList;
	}

	@Override
	public ReferenceSetImpl<ConceptSchemeBean> getConceptSchemeList() {
		return conceptSchemeList;
	}

	@Override
	protected void doChangeReference(IdentifiableBean toRemove,
			IdentifiableBean toAdd) {

		if (toRemove instanceof ConceptSchemeBean
				&& toAdd instanceof ConceptSchemeBean) {
			ConceptSchemeBean conceptScheme = (ConceptSchemeBean) toRemove;
			if (conceptSchemeList.contains(conceptScheme)) {
				conceptSchemeList.remove(conceptScheme);
				ConceptSchemeBean anotherScheme = (ConceptSchemeBean) toAdd;
				conceptSchemeList.add(anotherScheme);
			}
		} else if (toRemove instanceof UniverseSchemeBean
				&& toAdd instanceof UniverseSchemeBean) {
			UniverseSchemeBean universeScheme = (UniverseSchemeBean) toRemove;
			if (universeSchemeList.contains(universeScheme)) {
				universeSchemeList.remove(universeScheme);
				UniverseSchemeBean anotherScheme = (UniverseSchemeBean) toAdd;
				universeSchemeList.add(anotherScheme);
			}
		}
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		if (toRemove instanceof ConceptSchemeBean) {
			ConceptSchemeBean conceptScheme = (ConceptSchemeBean) toRemove;
			if (conceptSchemeList.contains(conceptScheme)) {
				conceptSchemeList.remove(conceptScheme);
			}
		} else if (toRemove instanceof UniverseSchemeBean) {
			UniverseSchemeBean universeScheme = (UniverseSchemeBean) toRemove;
			if (universeSchemeList.contains(universeScheme)) {
				universeSchemeList.remove(universeScheme);
			}
		}
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.ConceptualComponent;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return ConceptualComponentBean.class;
	}

}
