package org.openmetadata.beans.ddi.lifecycle.archive.impl;

import org.openmetadata.beans.ddi.lifecycle.archive.DDIMaintenanceAgencyIDBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class DDIMaintenanceAgencyIDBeanImpl extends UnsettableDdiBeanImpl
		implements DDIMaintenanceAgencyIDBean {

	private String registryID;

	public DDIMaintenanceAgencyIDBeanImpl(DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);
		registryID = null;
	}

	@Override
	public String getRegistryID() {
		return StringUtils.defaultString(registryID);
	}

	@Override
	public void setRegistryID(String value) {
		registryID = value;
		this.ddiBeanChanged();
	}
	
	@Override
	protected boolean internalIsSet() {
		return !StringUtils.isEmpty(registryID);
	}
}
