package org.openmetadata.beans.ddi.lifecycle.archive.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.CountryBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class CountryBeanImpl extends UnsettableDdiBeanImpl implements
		CountryBean {

	private String code;
	private String codeClass;
	private String stringValue;

	public CountryBeanImpl(DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		code = null;
		codeClass = null;
		stringValue = "";
	}

	@Override
	public String getCode() {
		return StringUtils.defaultString(code);
	}

	@Override
	public void setCode(String value) {
		code = value;
	}

	@Override
	public boolean isSetCode() {
		return !StringUtils.isEmpty(code);
	}

	@Override
	public String getCodeClass() {
		return StringUtils.defaultString(codeClass);
	}

	@Override
	public void setCodeClass(String value) {
		codeClass = value;
	}

	@Override
	public boolean isSetCodeClass() {
		return !StringUtils.isEmpty(codeClass);
	}

	@Override
	public String getStringValue() {
		return StringUtils.defaultString(stringValue);
	}

	@Override
	public void setStringValue(String value) {
		stringValue = value;
	}
	
	@Override
	protected boolean internalIsSet() {
		return !StringUtils.isEmpty(stringValue);
	}
}
