/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import java.util.HashMap;
import java.util.Map;
import org.openmetadata.beans.ddi.lifecycle.OpenMetadataKey;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.KeyedValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.LanguageKeyedBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.LanguageKeyedValueBean;
import org.openmetadata.beans.notification.ChangeListener;

public abstract class LanguageKeyedValueBeanImpl<B extends LanguageKeyedBean>
extends KeyedValueBeanImpl<B>
implements LanguageKeyedValueBean<B> {
    private static final String DEFAULT_LANG = "en";

    protected abstract B createNewBean(String var1, Map<Enum<?>, Object> var2);

    public LanguageKeyedValueBeanImpl(Class<B> beanClass, DdiBeanFactory beanFactory, ChangeListener changeListener) {
        super(beanClass, beanFactory, changeListener);
    }

    @Override
    protected final B createNewBean(Map<Enum<?>, Object> keyMap) {
        if (keyMap.containsKey((Object)OpenMetadataKey.LANG)) {
            String lang = (String)keyMap.get((Object)OpenMetadataKey.LANG);
            return this.createNewBean(lang, keyMap);
        }
        return this.createNewBean(DEFAULT_LANG, keyMap);
    }

    @Override
    public B getBean(String lang, Map<Enum<?>, Object> keyMap) {
        Map<Enum<?>, Object> langKeyMap = this.cloneMap(keyMap);
        langKeyMap.put(OpenMetadataKey.LANG, lang);
        return (B)((LanguageKeyedBean)this.getBean(langKeyMap));
    }

    @Override
    public B getBean(String lang) {
        HashMap keys = new HashMap();
        keys.put(OpenMetadataKey.LANG, lang);
        return (B)((LanguageKeyedBean)this.getBean(keys));
    }

    private Map<Enum<?>, Object> cloneMap(Map<Enum<?>, Object> keyMap) {
        HashMap tmpMap = new HashMap();
        for (Map.Entry<Enum<?>, Object> entry : keyMap.entrySet()) {
            tmpMap.put(entry.getKey(), entry.getValue());
        }
        return tmpMap;
    }

    @Override
    public B[] findBeans(String lang) {
        HashMap<OpenMetadataKey, String> query = new HashMap<OpenMetadataKey, String>();
        query.put(OpenMetadataKey.LANG, lang);
        return (LanguageKeyedBean[])this.findBeans(query);
    }

    @Override
    public void removeAllByLanguage(String lang) {
        HashMap keys = new HashMap();
        keys.put(OpenMetadataKey.LANG, lang);
        this.removeAll(keys);
    }
}

