/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.InitializingSchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ResolvingSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.BaseRecordLayoutBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.RecordLayoutBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.RecordLayoutSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class RecordLayoutSchemeBeanImpl
extends AbstractMaintainableBeanImpl
implements RecordLayoutSchemeBean {
    private InitializingSchemeItemList<RecordLayoutBean> recordLayoutList;
    private Set<String> otherBaseRecordLayoutUrns = new HashSet<String>();

    public RecordLayoutSchemeBeanImpl(Boolean isNewInstance, URN urn, MutableBeanInitializer beanInitializer, DdiBeanFactory factory) {
        super(isNewInstance, urn, beanInitializer, factory);
        this.recordLayoutList = new ResolvingSchemeItemListImpl<RecordLayoutBean>(this.getUrn(), RecordLayoutBean.class, beanInitializer, factory, (ChangeListener)this);
    }

    public void initSetRecordLayouts(String[] urns) {
        this.recordLayoutList.initSetIdentifiableUrns(urns);
        this.otherBaseRecordLayoutUrns.removeAll(Arrays.asList(this.recordLayoutList.getUrns()));
    }

    public void initSetBaseRecordLyaouts(String[] urns) {
        HashSet<String> allBaseRecordLayoutUrns = new HashSet<String>();
        allBaseRecordLayoutUrns.addAll(Arrays.asList(urns));
        this.otherBaseRecordLayoutUrns.clear();
        this.otherBaseRecordLayoutUrns.addAll(allBaseRecordLayoutUrns);
        this.otherBaseRecordLayoutUrns.removeAll(Arrays.asList(this.recordLayoutList.getUrns()));
    }

    @Override
    public BaseRecordLayoutBean[] getBaseRecordLayouts() {
        ArrayList<RecordLayoutBean> list = new ArrayList<RecordLayoutBean>();
        for (RecordLayoutBean rl : this.recordLayoutList) {
            list.add(rl);
        }
        try {
            Set recordLayouts = this.getResolver().resolve(BaseRecordLayoutBean.class, this.otherBaseRecordLayoutUrns);
            list.addAll(recordLayouts);
        }
        catch (ResolverException e) {
            throw new RuntimeException(e);
        }
        return list.toArray(new BaseRecordLayoutBean[0]);
    }

    protected void setRecordLayoutList(InitializingSchemeItemList<RecordLayoutBean> recordLayoutList) {
        this.recordLayoutList = recordLayoutList;
    }

    public InitializingSchemeItemList<RecordLayoutBean> getRecordLayouts() {
        return this.recordLayoutList;
    }

    @Override
    public void doChangeReference(IdentifiableBean current, IdentifiableBean another) {
    }

    @Override
    protected void doRemoveReference(IdentifiableBean toRemove) {
    }

    @Override
    public DdiClass getDdiClass() {
        return DdiClass.RecordLayoutScheme;
    }

    @Override
    public Class<? extends IdentifiableBean> getBeanType() {
        return RecordLayoutSchemeBean.class;
    }
}

