/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.impl;

import java.util.ArrayList;
import java.util.List;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractSchemeItemBean;
import org.openmetadata.beans.exceptions.FactoryException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class UniverseBeanImpl
extends AbstractSchemeItemBean<UniverseSchemeBean>
implements UniverseBean {
    private static boolean DEFAULT_IS_INCLUSIVE = true;
    private Boolean isInclusive;
    private UniverseBean parentUniverse = null;
    private final List<UniverseBean> subUniverseList = new ArrayList<UniverseBean>();

    public UniverseBeanImpl(Boolean isNewInstance, URN urn, MutableBeanInitializer beanInitializer, DdiBeanFactory factory) {
        super((boolean)isNewInstance, urn, beanInitializer, factory);
    }

    public void setParentUniverse(UniverseBean parent) {
        this.parentUniverse = parent;
        this.change();
    }

    protected void removeParentUniverse() {
        this.parentUniverse = null;
        this.change();
    }

    public void addSubUniverse(UniverseBean subUniverse) {
        this.subUniverseList.add(subUniverse);
        if (subUniverse instanceof UniverseBeanImpl) {
            UniverseBeanImpl subUniImpl = (UniverseBeanImpl)subUniverse;
            subUniImpl.setParentUniverse(this);
        }
    }

    @Override
    public boolean getIsInclusive() {
        if (this.isSetIsInclusive()) {
            return this.isInclusive;
        }
        return DEFAULT_IS_INCLUSIVE;
    }

    @Override
    public void setIsInclusive(boolean isInclusive) {
        this.isInclusive = isInclusive;
        this.change();
    }

    @Override
    public boolean isSetIsInclusive() {
        return this.isInclusive != null;
    }

    @Override
    public UniverseBean[] getSubUniverses() {
        return this.subUniverseList.toArray(new UniverseBean[0]);
    }

    @Override
    public boolean removeSubUniverse(UniverseBean subUniverse) {
        boolean result = this.subUniverseList.remove(subUniverse);
        this.change();
        return result;
    }

    @Override
    public UniverseBean addNewSubUniverse() throws FactoryException {
        DdiBeanFactory factory = this.getBeanFactory();
        UniverseBean subUniverse = null;
        if (factory != null) {
            subUniverse = factory.newInstance(UniverseBean.class, this.getContainerIdentifier());
            ((UniverseBeanImpl)subUniverse).setParentUniverse(this);
            this.subUniverseList.add(subUniverse);
            return subUniverse;
        }
        throw new FactoryException("Factory is not set in " + this.getBeanType().getSimpleName());
    }

    @Override
    public UniverseBean getParentUniverse() {
        return this.parentUniverse;
    }

    @Override
    public boolean isSubUniverse() {
        return this.parentUniverse != null;
    }

    @Override
    protected void doChangeReference(IdentifiableBean toRemove, IdentifiableBean toAdd) {
    }

    @Override
    protected void doRemoveReference(IdentifiableBean toRemove) {
    }

    @Override
    public boolean canMergeFrom(UniverseBean from) {
        return UniverseBeanImpl.areSiblings(this, from);
    }

    @Override
    public void mergeFrom(UniverseBean from) throws FactoryException {
        if (this.canMergeFrom(from)) {
            UniverseBeanImpl.transferSubUniverses(from, this);
            IdentifiableBean[] identifiableBeanArray = from.getReferrers();
            int n = identifiableBeanArray.length;
            int n2 = 0;
            while (n2 < n) {
                IdentifiableBean referrer = identifiableBeanArray[n2];
                try {
                    referrer.changeReference(from, this);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            if (from.isSubUniverse()) {
                UniverseBean parentUniverse = from.getParentUniverse();
                parentUniverse.removeSubUniverse(from);
            } else {
                UniverseSchemeBean scheme = (UniverseSchemeBean)from.getParentScheme();
                scheme.getUniverses().remove(from);
            }
        }
    }

    private static void transferSubUniverses(UniverseBean from, UniverseBean into) throws FactoryException {
        if (UniverseBeanImpl.areSiblings(from, into) && from != into) {
            UniverseBean[] fromSubUniverses;
            UniverseBean[] universeBeanArray = fromSubUniverses = from.getSubUniverses();
            int n = fromSubUniverses.length;
            int n2 = 0;
            while (n2 < n) {
                UniverseBean fromSubUniverse = universeBeanArray[n2];
                UniverseBean intoSubUniverse = into.addNewSubUniverse();
                intoSubUniverse.copyNameLabelDescription(fromSubUniverse);
                UniverseBeanImpl.transferSubUniverses(fromSubUniverse, intoSubUniverse);
                IdentifiableBean[] identifiableBeanArray = fromSubUniverse.getReferrers();
                int n3 = identifiableBeanArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IdentifiableBean referrer = identifiableBeanArray[n4];
                    referrer.changeReference(fromSubUniverse, intoSubUniverse);
                    ++n4;
                }
                from.removeSubUniverse(fromSubUniverse);
                ++n2;
            }
        }
    }

    private static boolean areSiblings(UniverseBean u1, UniverseBean u2) {
        if (u1 != null && u2 != null && u1.isSubUniverse() == u2.isSubUniverse()) {
            if (u1.isSubUniverse()) {
                return u1.getParentUniverse() == u2.getParentUniverse();
            }
            return u1.getParentScheme() == u2.getParentScheme();
        }
        return false;
    }

    @Override
    public DdiClass getDdiClass() {
        return DdiClass.Universe;
    }

    @Override
    public Class<? extends IdentifiableBean> getBeanType() {
        return UniverseBean.class;
    }
}

