/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptualComponentBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class ConceptualComponentBeanImpl
extends AbstractMaintainableBeanImpl
implements ConceptualComponentBean {
    private ReferenceSetImpl<ConceptSchemeBean> conceptSchemeList;
    private ReferenceSetImpl<UniverseSchemeBean> universeSchemeList;

    public ConceptualComponentBeanImpl(Boolean isNewInstance, URN urn, MutableBeanInitializer beanInitializer, DdiBeanFactory factory) {
        super(isNewInstance, urn, beanInitializer, factory);
        this.conceptSchemeList = new ReferenceSetImpl<ConceptSchemeBean>(ConceptSchemeBean.class, beanInitializer, factory, (ChangeListener)this);
        this.universeSchemeList = new ReferenceSetImpl<UniverseSchemeBean>(UniverseSchemeBean.class, beanInitializer, factory, (ChangeListener)this);
    }

    public void initSetConceptSchemes(String[] conceptSchemeUrns) {
        this.conceptSchemeList.initReferenceUrns(conceptSchemeUrns);
    }

    public void initSetUniverseSchemes(String[] universeSchemeUrns) {
        this.universeSchemeList.initReferenceUrns(universeSchemeUrns);
    }

    public ReferenceSetImpl<UniverseSchemeBean> getUniverseSchemeList() {
        return this.universeSchemeList;
    }

    public ReferenceSetImpl<ConceptSchemeBean> getConceptSchemeList() {
        return this.conceptSchemeList;
    }

    @Override
    protected void doChangeReference(IdentifiableBean toRemove, IdentifiableBean toAdd) {
        UniverseSchemeBean universeScheme;
        if (toRemove instanceof ConceptSchemeBean && toAdd instanceof ConceptSchemeBean) {
            ConceptSchemeBean conceptScheme = (ConceptSchemeBean)toRemove;
            if (this.conceptSchemeList.contains(conceptScheme)) {
                this.conceptSchemeList.remove(conceptScheme);
                ConceptSchemeBean anotherScheme = (ConceptSchemeBean)toAdd;
                this.conceptSchemeList.add(anotherScheme);
            }
        } else if (toRemove instanceof UniverseSchemeBean && toAdd instanceof UniverseSchemeBean && this.universeSchemeList.contains(universeScheme = (UniverseSchemeBean)toRemove)) {
            this.universeSchemeList.remove(universeScheme);
            UniverseSchemeBean anotherScheme = (UniverseSchemeBean)toAdd;
            this.universeSchemeList.add(anotherScheme);
        }
    }

    @Override
    protected void doRemoveReference(IdentifiableBean toRemove) {
        UniverseSchemeBean universeScheme;
        if (toRemove instanceof ConceptSchemeBean) {
            ConceptSchemeBean conceptScheme = (ConceptSchemeBean)toRemove;
            if (this.conceptSchemeList.contains(conceptScheme)) {
                this.conceptSchemeList.remove(conceptScheme);
            }
        } else if (toRemove instanceof UniverseSchemeBean && this.universeSchemeList.contains(universeScheme = (UniverseSchemeBean)toRemove)) {
            this.universeSchemeList.remove(universeScheme);
        }
    }

    @Override
    public DdiClass getDdiClass() {
        return DdiClass.ConceptualComponent;
    }

    @Override
    public Class<? extends IdentifiableBean> getBeanType() {
        return ConceptualComponentBean.class;
    }
}

