package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.ddi.lifecycle.reusable.AttributeSet;

public class AttributeSetImpl implements AttributeSet {
	
	private Map<String, String> dfAttrSet;
	private Map<String, Map<String, String>> nsAttrSet;
	
	protected Map<String, String> getInternalDefaultAttrSet(){
		if(dfAttrSet == null){
			dfAttrSet = 
					new HashMap<String, String>();
		}
		return dfAttrSet;
	}
	
	protected Map<String, Map<String, String>> getInternalNSAttrSet(){
		if(nsAttrSet == null){
			nsAttrSet = 
					new HashMap<String, Map<String, String>>();
		}
		return nsAttrSet;
	}
	
	public void initAdd(String ns, String key, String value) {
		if(ns!=null && ns.isEmpty()==false){		
			if(getInternalNSAttrSet().containsKey(ns)){
				getInternalNSAttrSet().get(ns).put(key, value);
			}else{
				Map<String, String> map = new HashMap<String, String>();
				map.put(key, value);
				getInternalNSAttrSet().put(ns, map);
			}
		}else{
			this.getInternalDefaultAttrSet().put(key, value);
		}
	}
	
	@Override
	public boolean containsKey(String key) {
		return getInternalDefaultAttrSet().containsKey(key);
	}
	
	@Override
	public boolean containsKey(String namespace, String key) {
		if(getInternalNSAttrSet().containsKey(namespace)){
			return getInternalNSAttrSet().get(namespace).containsKey(key);
		}else{
			return false;
		}
	}

	@Override
	public String getValue(String key) {
		String value = getInternalDefaultAttrSet().get(key);
		return StringUtils.defaultString(value);
	}

	@Override
	public String getValue(String namespace, String key) {
		Map<String, String> map = getInternalNSAttrSet().get(namespace);
		if(map!=null){
			String value = map.get(key);
			return StringUtils.defaultString(value);
		}else{
			return "";
		}
	}
}
