package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import java.util.ArrayList;
import java.util.List;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.SchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ResolvingSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.SchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ControlConstructBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.DynamicTextValueBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.InstrumentBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.CodeValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.SoftwareBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CodeValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public class InstrumentBeanImpl extends AbstractMaintainableBeanImpl implements
		InstrumentBean {

	private DynamicTextValueBeanImpl instructionText;
	private final ReferenceBeanImpl<ControlConstructBean> controlConstructRef;	
	private final List<String> externalInstumentLocations;	
	private final SchemeItemListImpl<SoftwareBean> softwareList;
	
	private CodeValueBean type;

	public InstrumentBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory) {
		super(isNewInstance, urn, beanInitializer, beanFactory);

		instructionText = new DynamicTextValueBeanImpl(beanFactory, this);
		
		softwareList = new ResolvingSchemeItemListImpl<SoftwareBean>(				
				urn.toString(), SoftwareBean.class, beanInitializer,
				beanFactory, this);

		controlConstructRef = new ReferenceBeanImpl<ControlConstructBean>(
				ControlConstructBean.class, beanFactory, this);
		
		externalInstumentLocations = new ArrayList<String>();
	}
	
	public void initSetSoftwareList(String[] softwareUrns){
		softwareList.initSetIdentifiableUrns(softwareUrns);
	}
	
	public void initSetControlConstruct(String controlConstructUrn) throws URNFormatException{
		controlConstructRef.setReferenceUrn(controlConstructUrn);
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.Instrument;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return InstrumentBean.class;
	}

	@Override
	public DynamicTextValueBean getInstructText() {
		return instructionText;
	}

	@Override
	public CodeValueBean getType() {
		if(type==null){
			type = new CodeValueBeanImpl(this.getBeanFactory(), this);
		}
		return type;
	}

	@Override
	public SchemeItemList<SoftwareBean> getSoftwareList() {
		return softwareList;
	}

	@Override
	public List<String> getExternalInstrumentLocations() {
		return externalInstumentLocations;
	}

	@Override
	public boolean isSetControlConstruct() {
		return controlConstructRef.isSet();
	}

	@Override
	public void setControlConstruct(ControlConstructBean bean) {
		controlConstructRef.setReferenceTo(bean);
	}

	@Override
	public ControlConstructBean getControlConstruct() {
		try {
			return controlConstructRef.getReferredObject();
		} catch (ResolverException e) {
			return null;
		}
	}
	
	@Override
	public String getControlConstructUrn() {
		return controlConstructRef.getUrn();
	}

	@Override
	public void unsetControlConstruct() {
		controlConstructRef.unset();
	}

	@Override
	protected void doChangeReference(IdentifiableBean toRemove,
			IdentifiableBean toAdd) {

	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {

	}

}
