package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.GeneralInstructionBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.CommandBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CommandBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.StructuredStringValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class GeneralInstructionBeanImpl extends UnsettableDdiBeanImpl implements GeneralInstructionBean{
	public static final boolean IS_OVERRIDE_DEFAULT_RETURN_VALUE = false;
	
	private Boolean override;
	private StructuredStringValueBeanImpl description;
	private DdiBeanListImpl<CommandBean> commandList;

	public GeneralInstructionBeanImpl(
			final MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory,
			ChangeListener changeListener) {
		super(beanFactory, changeListener);
		
		description = new StructuredStringValueBeanImpl(beanFactory, this);
		
		commandList = new DdiBeanListImpl<CommandBean>(CommandBean.class, beanInitializer, beanFactory, this) {
			@Override
			protected CommandBean createNew() {
				return new CommandBeanImpl(GeneralInstructionBeanImpl.this.getBeanFactory(), GeneralInstructionBeanImpl.this);
			}
		};
	}
	
	@Override
	public boolean getIsOverride() {
		if(this.override != null){
			return this.override;
		}
		return IS_OVERRIDE_DEFAULT_RETURN_VALUE;
	}

	@Override
	public boolean isSetIsOverride() {
		return this.override != null;
	}

	@Override
	public void setIsOverride(boolean boo) {
		boolean applyChange = (this.override!=null && this.override!=boo) || (this.override==null); 
		if(applyChange){
			this.override = boo;
			ddiBeanChanged();
		}
	}

	@Override
	public void unsetIsOverride() {
		if(this.override != null){
			this.override = null;
			ddiBeanChanged();
		}
	}

	@Override
	public StructuredStringValueBeanImpl getDescription() {
		return description;
	}

	@Override
	public DdiBeanListImpl<CommandBean> getCommandList() {
		return commandList;
	}
	
	@Override
	protected boolean internalIsSet() {
		return commandList.size() > 0 || description.getAllValues().length > 0;
	}
}
