package org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.impl;

import java.util.ArrayList;
import java.util.List;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractSchemeItemBean;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.exceptions.FactoryException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeEvent.Type;
import org.openmetadata.beans.notification.impl.IdentifiableChangeEventImpl;

public class UniverseBeanImpl extends
		AbstractSchemeItemBean<UniverseSchemeBean> implements UniverseBean {

	private static boolean DEFAULT_IS_INCLUSIVE = true;
	private Boolean isInclusive;

	private UniverseBean parentUniverse;
	private final List<UniverseBean> subUniverseList = new ArrayList<UniverseBean>();

	public UniverseBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		this.parentUniverse = null;
	}

	// to use internally to reset parent universe and parent universe scheme;
	public void setParentUniverse(UniverseBean parent) {
		this.parentUniverse = parent;
		this.change();
	}

	protected void removeParentUniverse() {
		this.parentUniverse = null;
		this.change();
	}

	public void addSubUniverse(UniverseBean subUniverse) {
		this.subUniverseList.add(subUniverse);
		if (subUniverse instanceof UniverseBeanImpl) {
			UniverseBeanImpl subUniImpl = (UniverseBeanImpl) subUniverse;
			subUniImpl.setParentUniverse(this);
		}
	}

	@Override
	public boolean getIsInclusive() {
		if (isSetIsInclusive()) {
			return isInclusive;
		} else {
			return DEFAULT_IS_INCLUSIVE;
		}
	}

	@Override
	public void setIsInclusive(boolean isInclusive) {
		this.isInclusive = isInclusive;
		this.change();
	}

	@Override
	public boolean isSetIsInclusive() {
		return isInclusive != null;
	}

	@Override
	public UniverseBean[] getSubUniverses() {
		return this.subUniverseList.toArray(new UniverseBean[0]);
	}

	@Override
	public boolean removeSubUniverse(UniverseBean subUniverse) {
		boolean result = this.subUniverseList.remove(subUniverse);
		if (result) {
			// getResolver().unregisterIdentifiableBean(subUniverse);
		}
		this.change();
		return result;
	}

	@Override
	public UniverseBean addNewSubUniverse() throws FactoryException {

		DdiBeanFactory factory = this.getBeanFactory();
		UniverseBean subUniverse = null;

		if (factory != null) {
			subUniverse = factory.newInstance(UniverseBean.class,
					this.getContainerIdentifier());
			((UniverseBeanImpl) subUniverse).setParentUniverse(this);
			subUniverseList.add(subUniverse);
			return subUniverse;
		} else {
			throw new FactoryException("Factory is not set in "
					+ getBeanType().getSimpleName());
		}
	}

	@Override
	public UniverseBean getParentUniverse() {
		return this.parentUniverse;
	}

	@Override
	public boolean isSubUniverse() {
		return this.parentUniverse != null;
	}

	@Override
	protected void doChangeReference(IdentifiableBean toRemove,
			IdentifiableBean toAdd) {
		// TODO Auto-generated method stub
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
	}

	@Override
	public boolean canMergeFrom(UniverseBean from) {
		return areSiblings(this, from);
	}

	@Override
	public void mergeFrom(UniverseBean from) throws 
			FactoryException{
		if (this.canMergeFrom(from)) {
			transferSubUniverses(from, this);
			for (IdentifiableBean referrer : from.getReferrers()) {
				try {
					referrer.changeReference(from, this);
				} catch (RuntimeException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			if (from.isSubUniverse()) {
				UniverseBean parentUniverse = from.getParentUniverse();
				parentUniverse.removeSubUniverse(from);
			} else {
				UniverseSchemeBean scheme = from.getParentScheme();
				scheme.getUniverses().remove(from);
			}
		}
	}

	// recursively transfer children universes
	private static void transferSubUniverses(UniverseBean from,
			UniverseBean into) throws  FactoryException {
		if (areSiblings(from, into) && from != into) {
			UniverseBean[] fromSubUniverses = from.getSubUniverses();
			for (UniverseBean fromSubUniverse : fromSubUniverses) {
				UniverseBean intoSubUniverse = into.addNewSubUniverse();
				intoSubUniverse.copyNameLabelDescription(fromSubUniverse);
				// recursively call
				transferSubUniverses(fromSubUniverse, intoSubUniverse);
				
				for (IdentifiableBean referrer : fromSubUniverse.getReferrers()) {
					referrer.changeReference(fromSubUniverse, intoSubUniverse);
				}
				from.removeSubUniverse(fromSubUniverse);
			}
		}
	}

	private static boolean areSiblings(UniverseBean u1, UniverseBean u2) {
		if (u1 != null && u2 != null) {
			if (u1.isSubUniverse() == u2.isSubUniverse()) {
				if (u1.isSubUniverse()) {
					return (u1.getParentUniverse() == u2.getParentUniverse());
				} else {
					return (u1.getParentScheme() == u2.getParentScheme());
				}
			}
		}
		return false;
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.Universe;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return UniverseBean.class;
	}

}
