package org.openmetadata.beans.ddi.lifecycle.archive.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.archive.AddressBean;
import org.openmetadata.beans.ddi.lifecycle.archive.EmailBean;
import org.openmetadata.beans.ddi.lifecycle.archive.InstantMessagingBean;
import org.openmetadata.beans.ddi.lifecycle.archive.LocationBean;
import org.openmetadata.beans.ddi.lifecycle.archive.PrivacyCode;
import org.openmetadata.beans.ddi.lifecycle.archive.TelephoneBean;
import org.openmetadata.beans.ddi.lifecycle.archive.URLBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractIdentifiableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CodeValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.InternationalStringValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.PointBeanImpl;
import org.openmetadata.ddi_3_1.util.URN;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public class LocationBeanImpl extends AbstractIdentifiableBeanImpl implements
		LocationBean {

	private String type;
	private InternationalStringValueBeanImpl nickname;
	private DdiBeanListImpl<AddressBean> addressList;
	private CountryBeanImpl country;
	private DdiBeanListImpl<TelephoneBean> telephoneList;
	private DdiBeanListImpl<URLBean> urlList;
	private DdiBeanListImpl<EmailBean> emailList;
	private DdiBeanListImpl<InstantMessagingBean> instantMessagingList;
	private PointBeanImpl geographicalLocation;
	private CodeValueBeanImpl regionalCoverage;
	private PrivacyCode privacyCode;

	public LocationBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory) {
		super(isNewInstance, urn, beanInitializer, beanFactory);
		
		type = null;
		nickname = new InternationalStringValueBeanImpl(beanFactory, this);

		addressList = new DdiBeanListImpl<AddressBean>(AddressBean.class, beanInitializer, beanFactory, this) {
			@Override
			protected AddressBean createNew() {
				return new AddressBeanImpl(getBeanFactory(), this);
			}
		};

		country = new CountryBeanImpl(beanFactory, this);

		telephoneList = new DdiBeanListImpl<TelephoneBean>(TelephoneBean.class, beanInitializer, beanFactory, this) {
			@Override
			protected TelephoneBean createNew() {
				return new TelephoneBeanImpl(getBeanFactory(), this);
			}
		};

		urlList = new DdiBeanListImpl<URLBean>(URLBean.class, beanInitializer, beanFactory, this) {
			@Override
			protected URLBean createNew() {
				return new URLBeanImpl(getBeanFactory(), this);
			}
		};

		emailList = new DdiBeanListImpl<EmailBean>(EmailBean.class, beanInitializer, beanFactory, this) {
			@Override
			protected EmailBean createNew() {
				return new EmailBeanImpl(getBeanFactory(), this);
			}
		};

		instantMessagingList = new DdiBeanListImpl<InstantMessagingBean>(
				InstantMessagingBean.class, beanInitializer, beanFactory, this) {
			@Override
			protected InstantMessagingBean createNew() {
				return new InstantMessagingBeanImpl(getBeanFactory(), this);
			}
		};

		geographicalLocation = new PointBeanImpl(beanFactory, this);
		regionalCoverage = new CodeValueBeanImpl(beanFactory, this);
		
		privacyCode = null;
	}

	@Override
	public boolean isSetPrivacy() {
		return this.privacyCode != null;
	}
	
	@Override
	public void setPrivacy(PrivacyCode code) {
		privacyCode = code;
		this.change();
	}
	
	@Override
	public void unsetPrivacy() {
		privacyCode = null;
		this.change();
	}
	
	@Override
	public PrivacyCode getPrivacy() {
		if(privacyCode != null){
			return privacyCode;
		}else{
			return PrivacyCode.PUBLIC;
		}
	}
	
	@Override
	public String getType() {
		return StringUtils.defaultString(this.type);
	}

	@Override
	public void setType(String value) {
		this.type = value;
		this.change();
	}

	@Override
	public boolean isSetType() {
		return !StringUtils.isEmpty(this.type);
	}

	@Override
	public InternationalStringValueBeanImpl getNickname() {
		return nickname;
	}

	@Override
	public DdiBeanListImpl<AddressBean> getAddressList() {
		return addressList;
	}

	@Override
	public CountryBeanImpl getCountry() {
		return country;
	}

	@Override
	public DdiBeanListImpl<TelephoneBean> getTelephoneList() {
		return telephoneList;
	}

	@Override
	public DdiBeanListImpl<URLBean> getURLList() {
		return urlList;
	}

	@Override
	public DdiBeanListImpl<EmailBean> getEmailList() {
		return emailList;
	}

	@Override
	public DdiBeanListImpl<InstantMessagingBean> getInstantMessagingList() {
		return instantMessagingList;
	}

	@Override
	public PointBeanImpl getGeographicalLocation() {
		return geographicalLocation;
	}

	@Override
	public CodeValueBeanImpl getRegionalCoverage() {
		return regionalCoverage;
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.Location;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return LocationBean.class;
	}

	@Override
	public void doChangeReference(IdentifiableBean toDerefer,
			IdentifiableBean toRefer) {
		// do nothing
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// do nothing
	}
}
