package org.openmetadata.beans.ddi.lifecycle.adt;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.DdiBean;

public interface ReferenceSet<B extends IdentifiableBean> extends DdiBean,
		Iterable<B> {

	boolean contains(B bean);

	boolean contains(String urn);

	boolean add(B bean);

	boolean remove(B bean);

	boolean remove(String urn);

	B[] toArray(B[] arr);

	int size();

	String[] getUrns();

	void clear();
	
	void moveBefore(B move, B before);

	void moveAfter(B move, B after);
}
