/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import java.util.List;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CategoryBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeList;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.CodeBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeEvent;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.beans.notification.impl.CreationEvent;

public class CodeListImpl
extends DdiBeanListImpl<CodeBean>
implements CodeList<CodeBean> {
    private final CodeSchemeBean codeScheme;
    private final MutableBeanInitializer beanInitializer;
    private final ChangeListener changeListener;

    public CodeListImpl(CodeSchemeBean codeScheme, MutableBeanInitializer beanInitializer, DdiBeanFactory factory, ChangeListener changeListener) {
        super(CodeBean.class, beanInitializer, factory, changeListener);
        this.codeScheme = codeScheme;
        this.beanInitializer = beanInitializer;
        this.changeListener = changeListener;
    }

    public void internalAddCode(CodeBean code) {
        this.add(code);
    }

    @Override
    protected final CodeBean createNew() {
        return new CodeBeanImpl("0", this.codeScheme, this.beanInitializer, this.getBeanFactory(), this.changeListener);
    }

    @Override
    public boolean contains(String codeVal) {
        CodeBean code = this.getCode(codeVal);
        return code != null;
    }

    @Override
    public CodeBean getCode(String codeVal) {
        if (codeVal != null && !codeVal.isEmpty()) {
            List list = this.getInternalList();
            for (CodeBean code : list) {
                String val;
                if (code == null || !(val = code.getValue()).equals(codeVal)) continue;
                return code;
            }
        }
        return null;
    }

    @Override
    public void changeCode(String oldValue, String newValue) {
        CodeBean oldCode = this.getCode(oldValue);
        if (oldCode != null && !oldCode.equals(newValue)) {
            CategoryBean referredCategory = oldCode.getCategory();
            this.codeScheme.getCodeList().remove(oldCode);
            CodeBean newCode = this.codeScheme.getCodeList().addNew(newValue);
            newCode.setCategory(referredCategory);
        }
    }

    @Override
    public final CodeBean addNew(CategoryBean category, String codeVal) {
        if (!this.contains(codeVal)) {
            CodeBeanImpl code = new CodeBeanImpl(codeVal, this.codeScheme, this.beanInitializer, this.getBeanFactory(), this.changeListener);
            code.setCategory(category);
            this.add(code);
            this.notifyChange((ChangeEvent)new CreationEvent((IdentifiableBean)code));
            return code;
        }
        return null;
    }

    @Override
    public CodeBean addNew(String codeVal) {
        if (!this.contains(codeVal)) {
            CodeBeanImpl code = new CodeBeanImpl(codeVal, this.codeScheme, this.beanInitializer, this.getBeanFactory(), this.changeListener);
            this.add(code);
            this.notifyChange((ChangeEvent)new CreationEvent((IdentifiableBean)code));
            return code;
        }
        return null;
    }

    @Override
    public boolean remove(CodeBean bean) {
        if (bean != null) {
            bean.removeAllReferences();
            return super.remove(bean);
        }
        return false;
    }
}

